package gr.uoa.di.driver.enabling.vocabulary;

import eu.dnetlib.domain.enabling.Vocabulary;
import eu.dnetlib.domain.enabling.VocabularySearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;

import java.util.Locale;

import org.apache.log4j.Logger;

import com.googlecode.ehcache.annotations.Cacheable;

public class ISVocabularyLoader implements VocabularyLoader {

	private static Logger logger = Logger.getLogger(ISVocabularyLoader.class);
	private ISLookUp<Vocabulary> lookUp = null;

	@Cacheable(cacheName="vocabularyCache")
	public Vocabulary getVocabulary(String vocabularyName, Locale locale, Locale defaultLocale) {
		logger.debug("Getting vocabulary with name " + vocabularyName +  "_" + locale);
		
		Vocabulary vocabulary = null;
		VocabularySearchCriteria criteria = new VocabularySearchCriteria(vocabularyName + "_" + locale);

		if (vocabularyName == null) {
			logger.debug("There is no vocabulary name");
			return null;
		}
		
		try {
			vocabulary = lookUp.getUniqueResult(criteria);
			if (vocabulary == null && defaultLocale != null){
				logger.debug("Getting vocabulary with default locale");
				if (defaultLocale == null || defaultLocale.equals(Locale.ROOT)) {
					criteria = new VocabularySearchCriteria(vocabularyName);
					
				} else {
					criteria = new VocabularySearchCriteria(vocabularyName+"_"+defaultLocale);
				}
				
				vocabulary = lookUp.getUniqueResult(criteria);
			}
			
			
		} catch (ISLookUpException isle) {
			logger.debug("Error loading vocabulary " + vocabularyName, isle);
		}

		logger.debug("returning " + vocabulary);
		return vocabulary;

	}

	public void setLookUp(ISLookUp<Vocabulary> lookUp) {
		this.lookUp = lookUp;
	}

	public ISLookUp<Vocabulary> getLookUp() {
		return lookUp;
	}

}