package gr.uoa.di.driver.enabling.resultset;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;

public class SecurityAwareResultSet<D extends SecureDriverResource> implements
		ResultSet<D> {

	private Logger logger = Logger.getLogger(SecurityAwareResultSet.class);
	private ResultSet<D> resultSet = null;
	private ISLookUp<SecurityProfile> securityLookUp = null;

	@Override
	public void close() {
		resultSet.close();
	}

	@Override
	public List<D> get(int from, int to) {
		List<D> list = resultSet.get(from, to);

		try {
			Map<String, SecurityProfile> secProfiles = this
					.getSecurityProfiles(list);

			for (D d : list) {
				SecurityProfile secProfile = secProfiles.get(d.getResourceId());

				d.setSecurityProfile(secProfile);
			}
		} catch (ISLookUpException e) {
			logger.error("Error getting security profiles for resources");
		}

		return list;
	}
	@Override
	public List<String> getElements(int from, int to) {
		return resultSet.getElements(from, to);
	}

	@Override
	public boolean isAlive() {
		return resultSet.isAlive();
	}

	@Override
	public boolean isOpen() {
		return resultSet.isOpen();
	}

	@Override
	public int size() {
		return resultSet.size();
	}

	public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
		this.securityLookUp = securityLookUp;
	}

	public void setResultSet(ResultSet<D> resultSet) {
		this.resultSet = resultSet;
	}

	private Map<String, SecurityProfile> getSecurityProfiles(List<D> profiles)
			throws ISLookUpException {
		SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
		Map<String, SecurityProfile> map = new HashMap<String, SecurityProfile>();

		for (D d : profiles)
			crit.getDriverResourceIds().add(d.getResourceId());

		for (SecurityProfile secProfile : securityLookUp.fetch(crit))
			map.put(secProfile.getDriverResourceId(), secProfile);

		return map;
	}

	@Override
	public EPR getEpr() {
		return this.resultSet.getEpr();
	}
}
