package gr.uoa.di.driver.enabling.resultset;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.api.enabling.ResultSetService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.util.ObjectToXmlConverter;
import eu.dnetlib.utils.resolver.EndpointResolver;
import gr.uoa.di.driver.enabling.ISLookUp;

public class ResultSetFactoryImpl implements ResultSetFactory {
	private static Logger logger = Logger.getLogger(ResultSetFactoryImpl.class);
	private Map<Class<?>, ObjectToXmlConverter<?>> converterMap = new HashMap<Class<?>, ObjectToXmlConverter<?>>();
	private ISLookUp<SecurityProfile> securityLookUp = null;
	private EndpointResolver endpointResolver = null;

    @Override
	public <D> ResultSet<D> createResultSet(ResultSet<?> rs,
			Class<D> resourceClass) {
		return createResultSet(rs.getEpr(), resourceClass);
	}

    @Override
	public ResultSet<String> createResultSet(EPR epr) {
		return createResultSet(epr, String.class);
	}
	
	@SuppressWarnings("unchecked")
    @Override
	public <D> ResultSet<D> createResultSet(EPR epr, Class<D> resourceClass) {
		logger.debug("Creating result set for resource type: "
				+ resourceClass.getSimpleName() + " and RSService: " + epr.getAddress());
		
		ResultSetImpl<D> rs = null;
		ResultSetService rsService = endpointResolver.getService(ResultSetService.class, epr);
		String rsIdentifier = epr.getParameter("ResourceIdentifier");
		
		if (resourceClass.equals(String.class)) {
			rs = new ResultSetImpl<D>(rsService, rsIdentifier);
		} else {

			ObjectToXmlConverter<D> converter = (ObjectToXmlConverter<D>) converterMap
					.get(resourceClass);

			if (converter != null)
				rs = new ResultSetImpl<D>(rsService, rsIdentifier, converter);
		}
		
		return rs;
	}

    @Override
	public <D extends SecureDriverResource> ResultSet<D> createSecurityAwareRS(
			EPR epr, Class<D> resourceClass) {
		logger.debug("Creating security aware result set for resource type: "
				+ resourceClass.getSimpleName());
		
		SecurityAwareResultSet<D> rs = new SecurityAwareResultSet<D>();

		rs.setResultSet(createResultSet(epr, resourceClass));
		rs.setSecurityLookUp(securityLookUp);

		return rs;
	}

	public void setConverterMap(Map<Class<?>, ObjectToXmlConverter<?>> converterMap) {
		this.converterMap = converterMap;
	}

	public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
		this.securityLookUp = securityLookUp;
	}

	public void setEndpointResolver(EndpointResolver endpointResolver) {
		this.endpointResolver = endpointResolver;
	}
}