package gr.uoa.di.driver.enabling.registry;

import org.apache.log4j.Logger;

import eu.dnetlib.api.DriverService;
import eu.dnetlib.domain.ActionType;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.enabling.Notification;
import gr.uoa.di.driver.enabling.ISRegistry;
import gr.uoa.di.driver.enabling.ISRegistryException;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;

public class CacheAwareRegistryImpl<D extends DriverResource> implements ISRegistry<D> {
	private static Logger logger = Logger.getLogger(CacheAwareRegistryImpl.class);
	private ISRegistry<D> registry = null;
	private DriverService notificationService = null;
	private ResourceType resourceType = null;
	private ResourceToXmlConverter<D> converter = null;
	
	@Override
	public void delete(D object) throws ISRegistryException {
		logger.debug("Deleting object " + object.getResourceId());
		registry.delete(object);
		
		sendNotification(ActionType.DELETE, object);
	}

	@Override
	public D insertForValidation(D object) throws ISRegistryException {
		return registry.insertForValidation(object);
	}

	@Override
	public D save(D object) throws ISRegistryException {
		boolean newObject = (object.getResourceId() == null);

		logger.debug("saving object with id " + object.getResourceId());
		object = registry.save(object);
		
		if (newObject)
			sendNotification(ActionType.CREATE, object);
		else
			sendNotification(ActionType.UPDATE, object);
		
		return object;
	}
	
	private void sendNotification(ActionType actionType, D object) {
		try {
			if (logger.isDebugEnabled())
				logger.debug("Sending immediate notification to cache: ("
						+ actionType.getValue() + ", "
						+ resourceType.getValue());

			Notification notification = new Notification(null, converter
					.ObjectToXml(object), object.getResourceId(),
					this.resourceType, actionType);

			notificationService.notify(notification);
		} catch (Exception e) {
			logger.error("Error notifying service", e);
		}
	}

	public void setRegistry(ISRegistry<D> registry) {
		this.registry = registry;
	}

	public void setNotificationService(DriverService notificationService) {
		this.notificationService = notificationService;
	}

	public void setResourceType(ResourceType resourceType) {
		this.resourceType = resourceType;
	}

	public void setConverter(ResourceToXmlConverter<D> converter) {
		this.converter = converter;
	}
}
