package gr.uoa.di.driver.enabling.issn;

import eu.dnetlib.domain.enabling.Subscription;

/**
 * A wrapper class around the IS Subscription service.
 * @author <a href="mailto:antleb@di.uoa.gr">Antonis Lempesis</a>
 *
 */
public interface SubscriptionManager {

	/**
	 * Adds a new subscription. The subscription is added and is periodically
	 * refreshed. Its timeToLive option is ignored...
	 * 
	 * @param subscription 
	 */
	public void subscribe(Subscription subscription);
	
	/**
	 * Adds a subscription. If refresh is true, the timeToLive field of the 
	 * subscription is ignored and the subscription periodically refreshed. If
	 * refresh is false, the subscription is added and left to rot...
	 * 
	 * @param subscription
	 * @param refresh
	 */
	public void subscribe(Subscription subscription, boolean refresh);
	
	/**
	 * Removes a subscription...
	 * 
	 * @param subscriptionId
	 */
	public void unsubscribe(String subscriptionId);
}