package gr.uoa.di.driver.enabling.issn;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.enabling.Notification;

public class NotificationManagerImpl implements NotificationManager {
	private static Logger logger = Logger.getLogger(NotificationManagerImpl.class);
	
	private ExecutorService executor = null;
	private int threads = 2;
	private List<NotificationListener> listeners = new ArrayList<NotificationListener>();

	public int getThreads() {
		return threads;
	}

	public void setThreads(int threads) {
		this.threads = threads;
	}

	public void init() {
		executor = Executors.newFixedThreadPool(threads);
	}

	public void shutdown() {
		executor.shutdown();
	}

	@Override
	public void addListener(NotificationListener listener) {
		
		logger.debug("Adding listener of type " + listener.getClass());
		synchronized (listeners) {
			listeners.add(listener);
		}
	}

	@Override
	public void notify(Notification notification) {
		try {
			logger.debug("Notification received with type " 
					+ notification.getResourceType());
			executor.submit(new NotificationTask(notification));
		} catch (Exception e) {
			logger.error("Error processing notification.",e);
		}
	}

	private class NotificationTask implements Runnable {
		private Notification notification = null;

		public NotificationTask(Notification notification) {
			this.notification = notification;
		}

		public void run() {
			NotificationListener listenerArray[] = null;

			synchronized (listeners) {
				listenerArray = listeners.toArray(new NotificationListener[0]);
			}

			for (NotificationListener listener : listenerArray) {
				logger.debug("Notifying listener of type " + listener.getClass().getName()
						+ "with notification type " + notification.getResourceType());
				
				try {
					listener.processNotification(notification);
				} catch (Exception e) {
					logger.error("Error notifying listener", e);
				}
			}
		}
	}
	
}