package gr.uoa.di.driver.enabling.islookup.cache;

import eu.dnetlib.domain.SearchCriteria;

public class CriteriaCacheKey {
	private SearchCriteria criteria = null;
	private String XQuery = null;
	private Mode mode = null;
	
	enum Mode {
		/** Performs quick search */
		QUICK, 
		/** Performs a normal search, using a result set */
		RS;
	}

	public CriteriaCacheKey(SearchCriteria criteria, Mode mode) {
		this.criteria = criteria;
		this.mode = mode;
	}

	public SearchCriteria getCriteria() {
		return criteria;
	}

	public void setCriteria(SearchCriteria criteria) {
		this.criteria = criteria;
	}

	public Mode getMode() {
		return mode;
	}

	public void setMode(Mode mode) {
		this.mode = mode;
	}

	public String getXQuery() {
		return this.XQuery;
	}

	public void setXQuery(String XQuery) {
		this.XQuery = XQuery;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result
				+ ((criteria == null) ? 0 : criteria.hashCode());
		result = prime * result + ((mode == null) ? 0 : mode.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		CriteriaCacheKey other = (CriteriaCacheKey) obj;
		if (criteria == null) {
			if (other.criteria != null)
				return false;
		} else if (!criteria.equals(other.criteria))
			return false;
		if (mode == null) {
			if (other.mode != null)
				return false;
		} else if (!mode.equals(other.mode))
			return false;
		return true;
	}
}
