package gr.uoa.di.driver.enabling.islookup;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.log4j.Logger;

import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.SearchCriteria;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import eu.dnetlib.domain.enabling.SecurityProfileSearchCriteria;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.ISLookUpException;

public class SecurityAwareLookupImpl<R extends SecureDriverResource> implements
		ISLookUp<R> {

	private static Logger logger = Logger.getLogger(SecurityAwareLookupImpl.class);
	
	private ISLookUp<R> lookUp = null;
	
	private ISLookUp<SecurityProfile> securityLookUp = null;

	@Override
	public List<R> fetch(SearchCriteria criteria) throws ISLookUpException {
		logger.debug("fetching secure profiles");
		List<R> list = lookUp.fetch(criteria);

		logger.debug("Loading and assigning security profiles");
		Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(list);
		
		for (R r : list) {
			SecurityProfile secProfile = secProfiles.get(r.getResourceId());
			
			r.setSecurityProfile(secProfile);
		}

		return list;
	}

	@Override
	public List<String> fetch(String XQuery) throws ISLookUpException {
		return lookUp.fetch(XQuery);
	}

	@Override
	public R getById(String id) throws ISLookUpException {
		R r = lookUp.getById(id);
		
		r.setSecurityProfile(this.getSecurityProfile(id));
		
		return r;
	}

	@Override
	public List<R> getByid(String[] ids) throws ISLookUpException {
		List<R> list = new ArrayList<R>();
		
		for (String id:ids)
			list.add(lookUp.getById(id));
		
		logger.debug("Loading and assigning security profiles");
		Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(list);
		
		for (R r : list) {
			SecurityProfile secProfile = secProfiles.get(r.getResourceId());
			
			r.setSecurityProfile(secProfile);
		}
		
		return list;
	}

	@Override
	public R getUniqueResult(SearchCriteria criteria) throws ISLookUpException {
		R r = lookUp.getUniqueResult(criteria);
		
		if (r != null)
			r.setSecurityProfile(this.getSecurityProfile(r.getResourceId()));
		
		return r;
	}

	@Override
	public List<R> performQuickSearch(SearchCriteria criteria)
			throws ISLookUpException {
		List<R> list = this.lookUp.performQuickSearch(criteria);
		
		logger.debug("Loading and assigning security profiles");
		Map<String, SecurityProfile> secProfiles = this.getSecurityProfiles(list);
		
		for (R r : list) {
			SecurityProfile secProfile = secProfiles.get(r.getResourceId());
			
			r.setSecurityProfile(secProfile);
		}

		return list;
	}

	@Override
	public EPR search(SearchCriteria criteria) throws ISLookUpException {
		return lookUp.search(criteria);
	}

	@Override
	public EPR search(String XQuery) throws ISLookUpException {
		return lookUp.search(XQuery);
	}

	public void setLookUp(ISLookUp<R> lookUp) {
		this.lookUp = lookUp;
	}
	
	public void setSecurityLookUp(ISLookUp<SecurityProfile> securityLookUp) {
		this.securityLookUp = securityLookUp;
	}

	private Map<String, SecurityProfile> getSecurityProfiles(List<R> profiles)
			throws ISLookUpException {
		SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();
		Map<String, SecurityProfile> map = new HashMap<String, SecurityProfile>();

		for (R r : profiles)
			crit.getDriverResourceIds().add(r.getResourceId());
		
		for (SecurityProfile secProfile: securityLookUp.fetch(crit))
			map.put(secProfile.getDriverResourceId(), secProfile);
		
		return map;
	}
	
	private SecurityProfile getSecurityProfile(String resourceId)
			throws ISLookUpException {
		SecurityProfileSearchCriteria crit = new SecurityProfileSearchCriteria();

		crit.getDriverResourceIds().add(resourceId);

		return this.securityLookUp.getUniqueResult(crit);
	}
}