package gr.uoa.di.driver.enabling.islookup;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

import javax.xml.bind.JAXBException;

import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import eu.dnetlib.api.enabling.ISLookUpService;
import eu.dnetlib.domain.DriverResource;
import eu.dnetlib.domain.ResourceType;
import eu.dnetlib.domain.SecureDriverResource;
import eu.dnetlib.domain.enabling.SecurityProfile;
import gr.uoa.di.driver.app.DriverServiceImpl;
import gr.uoa.di.driver.enabling.ISLookUp;
import gr.uoa.di.driver.enabling.islookup.cache.CachingISLookUp;
import gr.uoa.di.driver.enabling.islookup.cache.DriverCacheManager;
import gr.uoa.di.driver.enabling.islookup.cache.LookUpEntryFactory;
import gr.uoa.di.driver.enabling.islookup.cache.SecurityAwareCacheManager;
import gr.uoa.di.driver.enabling.islookup.cache.SecurityAwareCachingISLookUp;
import gr.uoa.di.driver.enabling.resultset.ResultSetFactory;
import gr.uoa.di.driver.util.ServiceLocator;
import gr.uoa.di.driver.xml.ResourceToXmlConverter;
import gr.uoa.di.driver.xml.SecurityProfileXmlConverter;

public class ISLookUpFactory {

	private Map<Class<? extends DriverResource>, ISLookUp<? extends DriverResource>> lookUpMap = new HashMap<Class<? extends DriverResource>, ISLookUp<? extends DriverResource>>();
	private Map<Class<? extends DriverResource>, CachingISLookUp<? extends DriverResource>> cachingLookUpMap = new HashMap<Class<? extends DriverResource>, CachingISLookUp<? extends DriverResource>>();
	private Map<Class<? extends DriverResource>, Class<? extends Comparator<? extends DriverResource>>> comparatorClassMap = null;

	private ServiceLocator<ISLookUpService> lookupLocator = null;
	boolean useCache = false;
	private DriverServiceImpl service = null;
	private CacheManager cacheManager = null;
	private ResultSetFactory rsFactory = null;

	public void init() throws JAXBException {

		ISLookUpImpl<SecurityProfile> lookup = new ISLookUpImpl<SecurityProfile>();

		lookup.setConverter(new SecurityProfileXmlConverter());
		lookup.setLookupLocator(lookupLocator);
		lookup.setRsFactory(rsFactory);

		lookUpMap.put(SecurityProfile.class, lookup);
	}

	@SuppressWarnings("unchecked")
	public <D extends DriverResource> ISLookUp<D> createISLookUp(
			Class<D> resourceClass) throws InstantiationException,
			IllegalAccessException {

		ISLookUp<D> lookup = null;
		
		if (useCache) {
			CachingISLookUp<D> cLookup = (CachingISLookUp<D>) cachingLookUpMap.get(resourceClass);

			if (cLookup == null) {
				Ehcache idCache = this.getIdCache(resourceClass);
				Ehcache criteriaCache = this.getCriteriaCache(resourceClass);
				cLookup = new CachingISLookUp<D>();

				cLookup.setConverter(getConverter(resourceClass));
				cLookup.setLookupLocator(lookupLocator);
				cLookup.setIdCache(idCache);
				cLookup.setCriteriaCache(criteriaCache);
				
				if (SecureDriverResource.class.isAssignableFrom(resourceClass)) {
					SecurityAwareCachingISLookUp<SecureDriverResource> scLookup = new SecurityAwareCachingISLookUp<SecureDriverResource>();
					
					scLookup.setLookup((CachingISLookUp<SecureDriverResource>) cLookup);
					scLookup.setSecurityLookup((ISLookUp<SecurityProfile>) lookUpMap.get(SecurityProfile.class));
					
					cLookup = (CachingISLookUp<D>) scLookup;
				}

				// create CacheManager
				DriverCacheManager<D> cacheManager = null;

				if (SecureDriverResource.class.isAssignableFrom(resourceClass)) {
					cacheManager = (DriverCacheManager<D>) new SecurityAwareCacheManager<SecureDriverResource>();
				} else
					cacheManager = new DriverCacheManager<D>();

				cacheManager.setComparator(this.getComparator(resourceClass));
				cacheManager.setConverter(this.getConverter(resourceClass));
				cacheManager.setResourceType(getResourceType(resourceClass));
				cacheManager.setSecurityLookUp((ISLookUp<SecurityProfile>) this.lookUpMap.get(SecurityProfile.class));
				cacheManager.setIdCache(idCache);
				cacheManager.setCriteriaCache(criteriaCache);
				cacheManager.setService(service);

				cacheManager.init();

				cachingLookUpMap.put(resourceClass, cLookup);
			}

			lookup = cLookup;
		} else {
			lookup = (ISLookUp<D>) lookUpMap.get(resourceClass);

			if (lookup == null) {
				lookup = new ISLookUpImpl<D>();

				((ISLookUpImpl<D>) lookup).setConverter(this.getConverter(resourceClass));
				((ISLookUpImpl<D>) lookup).setLookupLocator(lookupLocator);
				((ISLookUpImpl<D>) lookup).setRsFactory(this.rsFactory);

				if (SecureDriverResource.class.isAssignableFrom(resourceClass)) {
					SecurityAwareLookupImpl<SecureDriverResource> secureLookup = new SecurityAwareLookupImpl<SecureDriverResource>();

					secureLookup.setLookUp((ISLookUp<SecureDriverResource>) lookup);
					secureLookup.setSecurityLookUp((ISLookUp<SecurityProfile>) lookUpMap.get(SecurityProfile.class));

					lookup = (ISLookUp<D>) secureLookup;
				}

				lookUpMap.put(resourceClass, lookup);
			}
		}

		return lookup;
	}

	private Map<Class<? extends DriverResource>, Class<? extends ResourceToXmlConverter<? extends DriverResource>>> converterClassMap = null;

	@SuppressWarnings("unchecked")
	private <D extends DriverResource> ResourceToXmlConverter<D> getConverter(
			Class<D> resourceClass) throws InstantiationException,
			IllegalAccessException {
		Class<? extends ResourceToXmlConverter<D>> converterClass = (Class<? extends ResourceToXmlConverter<D>>) converterClassMap
				.get(resourceClass);

		return converterClass.newInstance();
	}

	@SuppressWarnings("unchecked")
	private <D extends DriverResource> Comparator<D> getComparator(
			Class<D> resourceClass) throws InstantiationException,
			IllegalAccessException {
		Class<? extends Comparator<D>> comparatorClass = (Class<? extends Comparator<D>>) comparatorClassMap
				.get(resourceClass);

		if (comparatorClass != null)
			return comparatorClass.newInstance();
		else
			return null;
	}

	private Map<Class<? extends DriverResource>, ResourceType> resourceTypeMap = null;

	private <D extends DriverResource> ResourceType getResourceType(
			Class<D> resourceClass) {
		return this.resourceTypeMap.get(resourceClass);
	}

	private <D extends DriverResource> Ehcache getIdCache(Class<D> resourceClass)
			throws InstantiationException, IllegalAccessException {
		return createCache(resourceClass, resourceClass.getSimpleName() + ".id");
	}

	private <D extends DriverResource> Ehcache getCriteriaCache(
			Class<D> resourceClass) throws InstantiationException,
			IllegalAccessException {
		return createCache(resourceClass, resourceClass.getSimpleName()
				+ ".criteria");
	}

	private <D extends DriverResource> Ehcache createCache(
			Class<D> resourceClass, String name) throws InstantiationException,
			IllegalAccessException {
		LookUpEntryFactory<D> lookupFactory = new LookUpEntryFactory<D>();
	
		lookupFactory.setLookUpServiceLocator(lookupLocator);
		lookupFactory.setRsFactory(rsFactory);
		
		cacheManager.addCache(name);
		Ehcache cache = cacheManager.getEhcache(name);

		return new SelfPopulatingCache(cache, lookupFactory);
	}

	public void setLookupLocator(ServiceLocator<ISLookUpService> lookupLocator) {
		this.lookupLocator = lookupLocator;
	}

	public void setUseCache(boolean useCache) {
		this.useCache = useCache;
	}

	public void setService(DriverServiceImpl service) {
		this.service = service;
	}

	public void setCacheManager(CacheManager cacheManager) {
		this.cacheManager = cacheManager;
	}

	public void setConverterClassMap(
			Map<Class<? extends DriverResource>, Class<? extends ResourceToXmlConverter<? extends DriverResource>>> converterClassMap) {
		this.converterClassMap = converterClassMap;
	}

	public void setComparatorClassMap(
			Map<Class<? extends DriverResource>, Class<? extends Comparator<? extends DriverResource>>> comparatorClassMap) {
		this.comparatorClassMap = comparatorClassMap;
	}

	public void setResourceTypeMap(
			Map<Class<? extends DriverResource>, ResourceType> resourceTypeMap) {
		this.resourceTypeMap = resourceTypeMap;
	}

	public void setRsFactory(ResultSetFactory rsFactory) {
		this.rsFactory = rsFactory;
	}
}