package gr.uoa.di.driver.enabling.a2;

import eu.dnetlib.api.enabling.A2Service;
import eu.dnetlib.enabling.aas.ctx.tools.CodingContext;
import eu.dnetlib.enabling.aas.ctx.tools.SimpleContextRecoder;
import eu.dnetlib.enabling.aas.rmi.AuthenticateRequest;
import eu.dnetlib.enabling.aas.rmi.AuthenticateResp;
import eu.dnetlib.enabling.aas.rmi.AuthorizeRequest;
import eu.dnetlib.enabling.aas.rmi.AuthorizeResp;
import eu.dnetlib.enabling.aas.rmi.InvalidateRequest;
import eu.dnetlib.enabling.aas.rmi.TypedString;
import gr.uoa.di.driver.util.ServiceLocator;

public class A2WrapperImpl implements A2Wrapper {
	private ServiceLocator<A2Service> locator = null;

	public void setLocator(ServiceLocator<A2Service> locator) {
		this.locator = locator;
	}

	@Override
	public String authenticateService(String certificate) {
		// TODO check certificates
		String contextId = null;
		AuthenticateRequest request = new AuthenticateRequest();

		TypedString principals = this.createTypedString("certificate",
				certificate);
		//TypedString credentials = this.createTypedString("", "");
		
		TypedString principalsArray[] = new TypedString[] {principals};
		//TypedString credentialsArray[] = new TypedString[] {credentials};

		request.setPrincipals(principalsArray);
		// request.setCredentials(credentialsArray);

		AuthenticateResp a2Response = locator.getService()
				.authenticate(request);

		if (a2Response.getErrors() == null
				|| a2Response.getErrors().length == 0)
			contextId = a2Response.getContextId();

		return contextId;
	}

	@Override
	public String authenticateUser(String email, String password) {
		String contextId = null;
		AuthenticateRequest request = new AuthenticateRequest();

		TypedString principals = this.createTypedString("login", email);
		TypedString credentials = this.createTypedString("password", password);

		TypedString principalsArray[] = new TypedString[] {principals};
		TypedString credentialsArray[] = new TypedString[] {credentials};

		request.setPrincipals(principalsArray);
		request.setCredentials(credentialsArray);

		AuthenticateResp a2Response = locator.getService()
				.authenticate(request);

		if (a2Response.getErrors() == null
				|| a2Response.getErrors().length == 0) {

			contextId = a2Response.getContextId();
			//TODO remove
			contextId = "contextId";
		}

		return contextId;
	}

	@Override
	public boolean authorizeAction(String resource, String action,
			String contextId) {
		AuthorizeRequest request = new AuthorizeRequest();

		request.setContextId(contextId);

		TypedString resourceType = this.createTypedString(null, resource);
		TypedString actionType = this.createTypedString(null, action);

		request.setResource(resourceType);
		request.setAction(actionType);

		AuthorizeResp a2Response = locator.getService().authorize(request);

		return a2Response.isAuthorized();
	}

	@Override
	public String createSecurityContextChain(String contextIdA,
			String contextIdB) {
		String secCtxIdChain = null;
		SimpleContextRecoder recoder = new SimpleContextRecoder();

		CodingContext ctx = new CodingContext();
		ctx.secCtxId = contextIdA;
		secCtxIdChain = recoder.encode(ctx, secCtxIdChain, null);
		ctx.secCtxId = contextIdB;
		secCtxIdChain = recoder.encode(ctx, secCtxIdChain, null);
		secCtxIdChain = recoder.appendVersionPrefix(secCtxIdChain);

		return secCtxIdChain;
	}

	@Override
	public void invalidate(String contextId) {
		InvalidateRequest request = new InvalidateRequest();

		request.setContextId(contextId);

		locator.getService().invalidate(request);
	}

	private TypedString createTypedString(String type, String value) {
		TypedString string = new TypedString();

		string.setText(value);
		string.setType(type);

		return string;
	}

}
