package gr.uoa.di.driver.enabling.a2;

import eu.dnetlib.api.enabling.A2ServiceException;


public interface A2Wrapper {
	
	/**
	 * Authenticates a DRIVER user.
	 * 
	 * @param email
	 * @param password
	 * @return The security context id of the user or null if the authentication 
	 * fails
	 * @throws A2ServiceException
	 */
    public String authenticateUser(String email, String password) throws A2ServiceException;
    
    /**
     * Authenticates a DRIVER service
     * 
     * @param certificate
     * @return The security context id of the service or null if the authentication 
	 * fails
	 * 
     * @throws A2ServiceException
     */
    public String authenticateService(String certificate) throws A2ServiceException;
    
    /**
     * Requests authorization for a given action. Resources and actions are defined in the 
     * security policies that must have been to AAS prior to these call
     * 
     * @param resource
     * @param action
     * @param contextId
     * @return true if the action is authorized, false otherwise.
     * @throws A2ServiceException
     */
    public boolean authorizeAction(String resource, String action, String contextId) throws A2ServiceException;
    
    /**
     * Invalidates the given security context.
     * 
     * @param contextId the id of the context to invalidate.
     */
    public void invalidate(String contextId);
    
    /**
     * Chains 2 security contexts.
     * @param contextIdA
     * @param contextIdB
     * @return the security context chain
     */
    public String createSecurityContextChain(String contextIdA, String contextIdB);

}
