package gr.uoa.di.driver.enabling;

import eu.dnetlib.domain.DriverResource;

public interface ISRegistry<D extends DriverResource> {
	
	/**
	 * Saves the given object to IS.
	 * @param object The object to save.
	 * @return The new Object.
	 * @throws ISRegistryException 
	 */
	public D save(D object) throws ISRegistryException;

	/**
	 * Deletes the given object from the IS
	 * @param object the object to be deleted
	 * @throws ISRegistryException
	 */
	public void delete(D object) throws ISRegistryException;

	/**
	 * Saves the given object to IS. The object is not yet validated, in 
	 * contrast to the save method that fully saves the object
	 * @param object The object to save.
	 * @return The new Object.
	 * @throws ISRegistryException 
	 */
	public D insertForValidation(D object) throws ISRegistryException;
}