package gr.uoa.di.driver.data.browsedata;

import java.io.StringReader;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;

import org.apache.log4j.Logger;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

import eu.dnetlib.domain.data.BrowseData;

public class BrowseDataUtil {

	static XPathExpression FIELD_EXPR = null;
	static XPathExpression VALUE_EXPR = null;
	static XPathExpression COUNT_EXPR = null;
	static XPathExpression GROUP_RESULT_EXPR = null;
	
	static {
		XPathFactory factory = XPathFactory.newInstance();
		XPath xpath = factory.newXPath();
		//xpath.setNamespaceContext(new RSClientNSContext());

		try {
			FIELD_EXPR = xpath.compile("//groupresult/@field");
			VALUE_EXPR = xpath.compile("//value");
			COUNT_EXPR = xpath.compile("//count");
			GROUP_RESULT_EXPR = xpath.compile("//groupresult");
			
		} catch (XPathExpressionException e) {
			throw new RuntimeException("Failed to build xpath expression.", e);
		}
	}
	
	static Logger logger = Logger.getLogger(BrowseDataUtil.class);
	
	
	private static InputSource source(String message) {
		return 	new InputSource(new StringReader(message));
	}
	
	private static String parseString(String record, XPathExpression expr) {
		String result = null;
		try {
			result = (String) expr.evaluate(
					source(record), XPathConstants.STRING);

		} catch (XPathExpressionException xpee) {
			logger.error("Cannot parse record "
					+ record.replaceAll("\n", " "), xpee);
		}
		return result;
	}
	
	public static BrowseData parseRows(String record) {
		BrowseData bd = new BrowseData();
		
		try {
			NodeList nodes = (NodeList) GROUP_RESULT_EXPR.evaluate(source(record), XPathConstants.NODESET);
				
			for (int i = 0; i < nodes.getLength(); i++) {
				Node node = nodes.item(i);
				String field = node.getAttributes().getNamedItem("field").getTextContent();
				int count = 0;
				String value = null;
				
				for (int j = 0; j < node.getChildNodes().getLength(); j++) {
					Node child = node.getChildNodes().item(j);
					
					if (child.getLocalName().toLowerCase().equals("count"))
						count = Integer.parseInt(child.getTextContent());
					else if (child.getLocalName().toLowerCase().equals("value"))
						value = child.getTextContent();
				}
							
				bd.addFieldEntry(field, value, count);
			}
		} catch (XPathExpressionException e) {
			logger.warn("Error parsing index row.", e);
		}
		
		return bd;
	}

	public static String parseField(String record) {
		return parseString(record, FIELD_EXPR);
	}

	public static String parseValue(String record) {
		return parseString(record, VALUE_EXPR);
	}

	public static int parseCount(String record) {
		String text = parseString(record, COUNT_EXPR);
		int count = 0;
		try {
			count = Integer.parseInt(text);
		} catch (NumberFormatException nfe) {
			logger.error("Expected number in count, but found: " + text, nfe);
		}
		return count;
	}
}
