package eu.dnetlib.util;

import javax.xml.bind.JAXBException;

public interface ObjectToXmlConverter<D> {
	
	/**
	 * Converts the xml representation to a Java object.
	 * @param xml The xml representation to convert
	 * @return the Java object.
	 * @throws JAXBException
	 */
	public D XmlToObject(String xml) throws JAXBException;
	
	/**
	 * Converts the Java object to its xml representation.
	 * @param object The object to convert.
	 * @return the xml...
	 * @throws JAXBException
	 */
	public String ObjectToXml(D object) throws JAXBException;
}
