/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.utils.ws;

import com.sun.xml.bind.api.JAXBRIContext;
import deltix.qsrv.comm.xml.ThrowableTransientAnnotationReaderBuilder;
import deltix.qsrv.comm.xml.TransientAnnotationReader;
import eu.dnetlib.api.DriverService;
import eu.dnetlib.api.data.StoreService;
import eu.dnetlib.clients.data.store.ws.StoreServiceWSClient;
import eu.dnetlib.clients.enabling.aas.ws.AASClient;
import eu.dnetlib.clients.utils.ws.CompatibilityEndpointResolver;
import eu.dnetlib.clients.utils.ws.CompatibilityServiceLocator;
import eu.dnetlib.clients.utils.ws.JaxwsServiceLocator;
import eu.dnetlib.enabling.aas.rmi.A2Service;
import eu.dnetlib.enabling.is.lookup.rmi.ISLookUpService;
import eu.dnetlib.enabling.tools.DynamicServiceLocator;
import eu.dnetlib.enabling.tools.DynamicServiceLocatorLocationScorer;
import eu.dnetlib.enabling.tools.ServiceLocator;
import eu.dnetlib.enabling.tools.ServiceResolver;
import eu.dnetlib.enabling.tools.registration.ServiceNameResolver;
import eu.dnetlib.soap.cxf.StandaloneCxfEndpointReferenceBuilder;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import eu.dnetlib.utils.resolver.TransportConfiguration;
import gr.uoa.di.driver.util.FallBackServiceLocator;
import gr.uoa.di.driver.util.RefreshingServiceLocator;
import gr.uoa.di.driver.util.ServiceLocatorFactory;
import gr.uoa.di.driver.util.StaticServiceLocator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.JaxWsProxyFactoryBean;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompatibilityServiceLocatorFactory
implements ServiceLocatorFactory {
    private static Logger logger = Logger.getLogger(CompatibilityServiceLocatorFactory.class);
    private TransportConfiguration configuration = null;
    private Map<Class<?>, ServiceClientFactory<?>> clientMap = null;
    private CompatibilityEndpointResolver endpointResolver = null;
    private StandaloneCxfEndpointReferenceBuilder eprBuilder = null;
    private ServiceLocator<ISLookUpService> lookUpLocator = null;
    private DynamicServiceLocatorLocationScorer scorer = null;
    private ServiceNameResolver serviceNameResolver = null;
    private ServiceResolver serviceResolver = null;
    private ScheduledExecutorService executor = Executors.newScheduledThreadPool(2);
    private long locatorRefreshPeriod = 300000L;

    public void init() {
        logger.debug((Object)"Init...");
    }

    public <S extends DriverService> gr.uoa.di.driver.util.ServiceLocator<S> newServiceLocator(Class<S> serviceClass) {
        if (serviceClass.equals(eu.dnetlib.api.enabling.A2Service.class)) {
            throw new IllegalArgumentException("Cannot create dynamic locator for A2Service");
        }
        return this.newRefreshingServiceLocator(this.newDynamicServiceLocator(serviceClass));
    }

    public <S extends DriverService> gr.uoa.di.driver.util.ServiceLocator<S> newServiceLocator(Class<S> serviceClass, String serviceUrl) {
        if (serviceClass.equals(eu.dnetlib.api.enabling.A2Service.class)) {
            return this.newA2ServiceLocator(serviceUrl);
        }
        if (serviceClass.equals(StoreService.class)) {
            return this.newStoreServiceClient(serviceUrl);
        }
        return new FallBackServiceLocator(this.newRefreshingServiceLocator(this.newDynamicServiceLocator(serviceClass)), this.newUrlServiceLocator(serviceClass, serviceUrl));
    }

    private gr.uoa.di.driver.util.ServiceLocator<StoreService> newStoreServiceClient(String serviceUrl) {
        StoreServiceWSClient client = new StoreServiceWSClient(serviceUrl);
        StaticServiceLocator locator = new StaticServiceLocator();
        locator.setService((DriverService)client);
        return locator;
    }

    private <S extends DriverService> gr.uoa.di.driver.util.ServiceLocator<S> newRefreshingServiceLocator(gr.uoa.di.driver.util.ServiceLocator<S> locator) {
        RefreshingServiceLocator rLocator = new RefreshingServiceLocator();
        rLocator.setExecutor(this.executor);
        rLocator.setLocator(locator);
        rLocator.setPeriod(this.locatorRefreshPeriod);
        return rLocator;
    }

    private <S extends DriverService> gr.uoa.di.driver.util.ServiceLocator<S> newUrlServiceLocator(Class<S> serviceClass, String serviceUrl) {
        JaxwsServiceLocator<S> locator = new JaxwsServiceLocator<S>();
        locator.setEprBuilder(this.eprBuilder);
        locator.setServiceClass(serviceClass);
        locator.setUrl(serviceUrl);
        locator.setResolver(this.endpointResolver);
        return locator;
    }

    private <S extends DriverService> gr.uoa.di.driver.util.ServiceLocator<S> newDynamicServiceLocator(Class<S> serviceClass) {
        CompatibilityServiceLocator<Object> locator = new CompatibilityServiceLocator<Object>();
        DynamicServiceLocator serviceLocator = new DynamicServiceLocator();
        serviceLocator.setClazz(this.configuration.getEndpointClass(serviceClass));
        serviceLocator.setEprBuilder(this.eprBuilder);
        serviceLocator.setLookUpLocator(this.lookUpLocator);
        serviceLocator.setScorer(this.scorer);
        serviceLocator.setServiceNameResolver(this.serviceNameResolver);
        serviceLocator.setServiceResolver(this.serviceResolver);
        ServiceClientFactory<?> clientFactory = this.clientMap.get(serviceClass);
        locator.setClientFactory(clientFactory);
        locator.setServiceClass(serviceClass);
        locator.setServiceLocator((ServiceLocator<?>)serviceLocator);
        return locator;
    }

    private gr.uoa.di.driver.util.ServiceLocator<eu.dnetlib.api.enabling.A2Service> newA2ServiceLocator(String serviceUrl) {
        JaxWsProxyFactoryBean factory = new JaxWsProxyFactoryBean();
        factory.setServiceClass(A2Service.class);
        factory.setAddress(serviceUrl);
        JAXBDataBinding dataBinding = new JAXBDataBinding();
        HashMap<String, TransientAnnotationReader> contextProperties = new HashMap<String, TransientAnnotationReader>();
        try {
            contextProperties.put(JAXBRIContext.ANNOTATION_READER, new ThrowableTransientAnnotationReaderBuilder().buildInstance());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        dataBinding.setContextProperties(contextProperties);
        factory.setDataBinding((DataBinding)dataBinding);
        A2Service endpoint = (A2Service)factory.create();
        AASClient client = new AASClient();
        client.setA2Service(endpoint);
        StaticServiceLocator locator = new StaticServiceLocator((DriverService)client);
        return locator;
    }

    public StandaloneCxfEndpointReferenceBuilder getEprBuilder() {
        return this.eprBuilder;
    }

    public void setEprBuilder(StandaloneCxfEndpointReferenceBuilder eprBuilder) {
        this.eprBuilder = eprBuilder;
    }

    public ServiceLocator<ISLookUpService> getLookUpLocator() {
        return this.lookUpLocator;
    }

    public void setLookUpLocator(ServiceLocator<ISLookUpService> lookUpLocator) {
        this.lookUpLocator = lookUpLocator;
    }

    public DynamicServiceLocatorLocationScorer getScorer() {
        return this.scorer;
    }

    public void setScorer(DynamicServiceLocatorLocationScorer scorer) {
        this.scorer = scorer;
    }

    public ServiceNameResolver getServiceNameResolver() {
        return this.serviceNameResolver;
    }

    public void setServiceNameResolver(ServiceNameResolver serviceNameResolver) {
        this.serviceNameResolver = serviceNameResolver;
    }

    public ServiceResolver getServiceResolver() {
        return this.serviceResolver;
    }

    public void setServiceResolver(ServiceResolver serviceResolver) {
        this.serviceResolver = serviceResolver;
    }

    public TransportConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(TransportConfiguration configuration) {
        this.configuration = configuration;
    }

    public CompatibilityEndpointResolver getEndpointResolver() {
        return this.endpointResolver;
    }

    public void setEndpointResolver(CompatibilityEndpointResolver endpointResolver) {
        this.endpointResolver = endpointResolver;
    }

    public Map<Class<?>, ServiceClientFactory<?>> getClientMap() {
        return this.clientMap;
    }

    public void setClientMap(Map<Class<?>, ServiceClientFactory<?>> clientMap) {
        this.clientMap = clientMap;
    }
}

