/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.enabling.issn.ws;

import eu.dnetlib.api.enabling.ISSNService;
import eu.dnetlib.api.enabling.ISSNServiceException;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.enabling.is.sn.rmi.ISSNException;
import eu.dnetlib.utils.EPRUtils;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ISSNClient
implements ISSNService {
    private eu.dnetlib.enabling.is.sn.rmi.ISSNService service = null;
    private static Logger logger = Logger.getLogger(ISSNClient.class);

    public void setPortType(eu.dnetlib.enabling.is.sn.rmi.ISSNService portType) {
        this.service = portType;
    }

    public void setWebService(Object webService) {
        this.service = (eu.dnetlib.enabling.is.sn.rmi.ISSNService)webService;
    }

    public boolean actionCreatePerformed(String resourceType, String profileId, String profile) throws ISSNServiceException {
        try {
            return this.service.actionCreatePerformed(resourceType, profileId, profile);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"actionCreatePerformed error", (Throwable)e);
            throw new ISSNServiceException("actionCreatePerformed error");
        }
    }

    public boolean actionDeletePerformed(String resourceType, String profileId) throws ISSNServiceException {
        try {
            return this.service.actionDeletePerformed(resourceType, profileId);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"actionDeletePerformed error", (Throwable)e);
            throw new ISSNServiceException("actionDeletePerformed error");
        }
    }

    public boolean actionUpdatePerformed(String resourceType, String profileId, String profileBefore, String profileAfter) throws ISSNServiceException {
        try {
            return this.service.actionUpdatePerformed(resourceType, profileId, profileBefore, profileAfter);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"actionUpdatePerformed error", (Throwable)e);
            throw new ISSNServiceException("actionUpdatePerformed error");
        }
    }

    public String getCurrentMessage(String topic) throws ISSNServiceException {
        try {
            return this.service.getCurrentMessage(topic);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"getCurrentMessage error", (Throwable)e);
            throw new ISSNServiceException("getCurrentMessage error");
        }
    }

    public List<String> listSubscriptions() {
        return this.service.listSubscriptions();
    }

    public boolean pauseSubscription(String subscrId) throws ISSNServiceException {
        try {
            return this.service.pauseSubscription(subscrId);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error pausing subscription", (Throwable)e);
            throw new ISSNServiceException("Error pausing subscription");
        }
    }

    public boolean renew(String subscrId, int terminationTime) throws ISSNServiceException {
        try {
            return this.service.renew(subscrId, terminationTime);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error renewing subscription", (Throwable)e);
            throw new ISSNServiceException("Error renewing subscription");
        }
    }

    public boolean resumeSubscription(String subscrId) throws ISSNServiceException {
        try {
            return this.service.resumeSubscription(subscrId);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error resuming subscription", (Throwable)e);
            throw new ISSNServiceException("Error resuming subscription");
        }
    }

    public String subscribe(EPR consumerReference, String topicExpression, int initialTerminationTime) throws ISSNServiceException {
        try {
            W3CEndpointReference w3cEpr = EPRUtils.createW3CEPR((EPR)consumerReference);
            return this.service.subscribe(w3cEpr, topicExpression, initialTerminationTime);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error subscribing", (Throwable)e);
            throw new ISSNServiceException("Error subscribing");
        }
    }

    public boolean unsubscribe(String subscrId) throws ISSNServiceException {
        try {
            return this.service.unsubscribe(subscrId);
        }
        catch (ISSNException e) {
            throw new ISSNServiceException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)"Error unsubscribing", (Throwable)e);
            throw new ISSNServiceException("Error unsubscribing");
        }
    }

    public ServiceIdentity identify() {
        return null;
    }

    public void notify(Notification notification) {
        throw new UnsupportedOperationException();
    }
}

