/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.similarity.ws;

import eu.dnetlib.api.data.SimilarityService;
import eu.dnetlib.clients.data.publisher.ws.PublisherWSClientFactory;
import eu.dnetlib.clients.data.similarity.ws.SimilarityServiceWSClient;
import eu.dnetlib.data.information.similarity.ISimilarityService;
import eu.dnetlib.utils.resolver.ServiceClientFactory;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.constructs.blocking.CacheEntryFactory;
import net.sf.ehcache.constructs.blocking.SelfPopulatingCache;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityWSClientFactory
implements ServiceClientFactory<SimilarityService> {
    private static Logger logger = Logger.getLogger(PublisherWSClientFactory.class);
    private CacheManager cacheManager = null;
    private final String cacheName = "simlarityCache";

    public SimilarityService newClient(Object endpoint) {
        Ehcache cache = this.cacheManager.getEhcache("simlarityCache");
        SimilarityServiceWSClient client = new SimilarityServiceWSClient();
        if (cache == null) {
            this.cacheManager.addCache("simlarityCache");
        }
        cache = new SelfPopulatingCache(this.cacheManager.getEhcache("simlarityCache"), (CacheEntryFactory)new SimilarityServiceEntryFactory((ISimilarityService)endpoint));
        client.setClient((ISimilarityService)endpoint);
        client.setDocumentCache(cache);
        return client;
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public void setCacheManager(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    class SimilarityServiceEntryFactory
    implements CacheEntryFactory {
        private ISimilarityService client = null;

        public SimilarityServiceEntryFactory(ISimilarityService client) {
            this.client = client;
        }

        public Object createEntry(Object o) throws Exception {
            String documentId = (String)o;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Document with id " + documentId + "not found " + "in cache. Querying similarity service"));
            }
            return this.client.findSimilar(documentId, false);
        }
    }
}

