/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.similarity.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.SimilarityService;
import eu.dnetlib.data.information.similarity.DNetSimilarityResult;
import eu.dnetlib.data.information.similarity.ISimilarityService;
import eu.dnetlib.data.information.similarity.SimilarityServiceException;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.data.SimilarDocument;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.ServiceIdentityFactory;
import java.util.ArrayList;
import java.util.List;
import net.sf.ehcache.Ehcache;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimilarityServiceWSClient
implements SimilarityService {
    private ISimilarityService client = null;
    private Ehcache documentCache = null;
    private static Logger logger = Logger.getLogger(SimilarityServiceWSClient.class);

    public void setWebService(Object webService) {
        this.client = (ISimilarityService)webService;
    }

    public List<SimilarDocument> getSimilarDocuments(String id) {
        DNetSimilarityResult[] results = null;
        try {
            results = this.client.findSimilarDirectly(id, false);
        }
        catch (SimilarityServiceException e) {
            logger.error((Object)e);
        }
        ArrayList<SimilarDocument> list = new ArrayList<SimilarDocument>();
        if (results != null) {
            for (DNetSimilarityResult result : results) {
                SimilarDocument similarDocument = new SimilarDocument();
                logger.debug((Object)("similar doc with id '" + result.getId() + "'"));
                similarDocument.setId(result.getId());
                similarDocument.setScore(result.getScore());
                list.add(similarDocument);
            }
        }
        return list;
    }

    public ServiceIdentity identify() {
        return ServiceIdentityFactory.parseIdentity((String)this.client.identify());
    }

    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }

    public ISimilarityService getClient() {
        return this.client;
    }

    public void setClient(ISimilarityService client) {
        this.client = client;
    }

    public Ehcache getDocumentCache() {
        return this.documentCache;
    }

    public void setDocumentCache(Ehcache documentCache) {
        this.documentCache = documentCache;
    }
}

