/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.search.ws;

import eu.dnetlib.api.data.BrowseDataNotAvailableException;
import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.clients.data.search.ws.BrowseDataUpdateException;
import eu.dnetlib.clients.data.search.ws.SearchWebService;
import eu.dnetlib.clients.data.search.ws.SearchWebServiceException;
import eu.dnetlib.clients.data.search.ws.SuggestiveWebResult;
import eu.dnetlib.clients.ws.BaseDriverWebService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.data.BrowseData;
import eu.dnetlib.utils.EPRUtils;
import java.util.Collection;
import javax.jws.WebService;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@WebService(serviceName="SearchWebService", endpointInterface="eu.dnetlib.clients.data.search.ws.SearchWebService")
public class SearchWebServiceImpl
extends BaseDriverWebService<SearchService>
implements SearchWebService {
    @Override
    public BrowseData browse(String prefix, String field) throws BrowseDataUpdateException, SearchWebServiceException {
        try {
            return ((SearchService)this.service).browse(prefix, field);
        }
        catch (BrowseDataNotAvailableException bdna) {
            throw new BrowseDataUpdateException(bdna.getMessage());
        }
        catch (Exception e) {
            throw new SearchWebServiceException("Error in browse.", e);
        }
    }

    @Override
    public W3CEndpointReference refine(String query, Collection<String> fields) throws SearchWebServiceException {
        try {
            return EPRUtils.createW3CEPR((EPR)((SearchService)this.service).refine(query, fields));
        }
        catch (Exception e) {
            throw new SearchWebServiceException("Error in refine.", e);
        }
    }

    @Override
    public W3CEndpointReference search(String query) throws SearchWebServiceException {
        try {
            EPR epr = ((SearchService)this.service).search(query);
            W3CEndpointReference result = EPRUtils.createW3CEPR((EPR)epr);
            return result;
        }
        catch (Exception e) {
            throw new SearchWebServiceException("Error in search.", e);
        }
    }

    @Override
    public SuggestiveWebResult suggestiveSearch(String query) throws SearchWebServiceException {
        try {
            return new SuggestiveWebResult(((SearchService)this.service).suggestiveSearch(query));
        }
        catch (SearchServiceException e) {
            throw new SearchWebServiceException("Error in suggestation search", e);
        }
    }
}

