/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.search.ws;

import eu.dnetlib.api.data.BrowseDataNotAvailableException;
import eu.dnetlib.api.data.SearchService;
import eu.dnetlib.api.data.SearchServiceException;
import eu.dnetlib.clients.data.search.ws.BrowseDataUpdateException;
import eu.dnetlib.clients.data.search.ws.SearchWebService;
import eu.dnetlib.clients.ws.BaseWebServiceClient;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.data.BrowseData;
import eu.dnetlib.domain.data.SuggestiveResult;
import eu.dnetlib.utils.EPRUtils;
import java.util.Collection;
import javax.xml.ws.wsaddressing.W3CEndpointReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchWebServiceClient
extends BaseWebServiceClient<SearchWebService>
implements SearchService {
    public BrowseData browse(String prefix, String field) throws BrowseDataNotAvailableException, SearchServiceException {
        try {
            return ((SearchWebService)this.webService).browse(prefix, field);
        }
        catch (BrowseDataUpdateException bd) {
            throw new BrowseDataNotAvailableException(bd.getMessage());
        }
        catch (Exception e) {
            throw new SearchServiceException("Error in browse.", (Throwable)e);
        }
    }

    public EPR refine(String query, Collection<String> fields) throws SearchServiceException {
        try {
            return EPRUtils.createEPR((W3CEndpointReference)((SearchWebService)this.webService).refine(query, fields));
        }
        catch (Exception e) {
            throw new SearchServiceException("Error in refine.", (Throwable)e);
        }
    }

    public EPR search(String query) throws SearchServiceException {
        try {
            W3CEndpointReference epr = ((SearchWebService)this.webService).search(query);
            EPR result = EPRUtils.createEPR((W3CEndpointReference)epr);
            return result;
        }
        catch (Exception e) {
            throw new SearchServiceException("Error in search.", (Throwable)e);
        }
    }

    public SuggestiveResult suggestiveSearch(String query) throws SearchServiceException {
        try {
            return ((SearchWebService)this.webService).suggestiveSearch(query).toSuggestiveResult();
        }
        catch (Exception e) {
            throw new SearchServiceException("Error in suggestation", (Throwable)e);
        }
    }
}

