/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.clients.data.publisher.ws;

import eu.dnetlib.api.DriverServiceException;
import eu.dnetlib.api.data.PublisherServiceException;
import eu.dnetlib.data.information.publisher.rmi.PublisherService;
import eu.dnetlib.domain.EPR;
import eu.dnetlib.domain.ServiceIdentity;
import eu.dnetlib.domain.enabling.Notification;
import eu.dnetlib.utils.EPRUtils;
import java.io.Serializable;
import java.util.List;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import net.sf.ehcache.Ehcache;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublisherWSClient
implements eu.dnetlib.api.data.PublisherService {
    private static Logger logger = Logger.getLogger(PublisherWSClient.class);
    private PublisherService client = null;
    private Ehcache documentCache = null;

    public void setWebService(Object webService) {
        this.client = (PublisherService)webService;
    }

    public String getResourceById(String id, String format) throws PublisherServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Publisher lookup for id " + id + " with format " + format));
        }
        String resource = (String)((Object)this.documentCache.get((Serializable)((Object)(id + "@" + format))).getValue());
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Resource is " + resource));
        }
        return resource;
    }

    public EPR getResourcesByIds(List<String> ids, String format) throws PublisherServiceException {
        W3CEndpointReference epr = this.client.getResourcesByIds(ids, format);
        return EPRUtils.createEPR((W3CEndpointReference)epr);
    }

    public ServiceIdentity identify() {
        throw new UnsupportedOperationException();
    }

    public void notify(Notification notification) throws DriverServiceException {
        throw new UnsupportedOperationException();
    }

    public Ehcache getDocumentCache() {
        return this.documentCache;
    }

    public void setDocumentCache(Ehcache documentCache) {
        this.documentCache = documentCache;
    }

    public void setClient(PublisherService client) {
        this.client = client;
    }

    public PublisherService getClient() {
        return this.client;
    }
}

