/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java.jsonworkflownodes;

import eu.dnetlib.iis.core.TestsIOUtils;
import eu.dnetlib.iis.core.java.HadoopContext;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Process;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.io.JsonUtils;
import eu.dnetlib.iis.core.java.jsonworkflownodes.PortSpecifications;
import eu.dnetlib.iis.core.java.porttype.PortType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class TestingConsumer
implements Process {
    private final PortSpecifications inputSpecs;

    public TestingConsumer(String[] inputSpecifications) {
        this.inputSpecs = new PortSpecifications(inputSpecifications);
    }

    public Map<String, PortType> getInputPorts() {
        return this.inputSpecs.getPortTypes();
    }

    public Map<String, PortType> getOutputPorts() {
        return new HashMap<String, PortType>();
    }

    public void run(PortBindings portBindings, HadoopContext context, Map<String, String> parameters) throws Exception {
        Map input = portBindings.getInput();
        FileSystem fs = FileSystem.get((Configuration)context.getConfiguration());
        for (Map.Entry e : input.entrySet()) {
            PortSpecifications.SpecificationValues specs = this.inputSpecs.get((String)e.getKey());
            TestingConsumer.check(new FileSystemPath(fs, (Path)e.getValue()), specs);
        }
    }

    private static void check(FileSystemPath actualPath, PortSpecifications.SpecificationValues specs) throws IOException {
        List expected = JsonUtils.convertToList((String)specs.jsonFilePath, (Schema)specs.schema, SpecificRecord.class);
        List actual = DataStore.read((FileSystemPath)actualPath, (Schema)specs.schema);
        TestsIOUtils.assertEqualSets(expected, actual);
    }
}

