/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java.jsonworkflownodes;

import eu.dnetlib.iis.core.common.AvroUtils;
import eu.dnetlib.iis.core.java.jsonworkflownodes.PortSpec;
import eu.dnetlib.iis.core.java.jsonworkflownodes.PortsCreator;
import eu.dnetlib.iis.core.java.jsonworkflownodes.Producer;
import eu.dnetlib.iis.core.java.jsonworkflownodes.TestingConsumer;
import eu.dnetlib.iis.core.java.porttype.AvroPortType;
import eu.dnetlib.iis.core.java.porttype.PortType;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class ProducerAndConsumerTest {
    @Test
    public void testPortCreationInProducer() {
        this.checkPortsCreator(new PortsCreator(){

            @Override
            public Map<String, PortType> getPorts(String[] specificationStrings) {
                Producer producer = new Producer(specificationStrings);
                Assert.assertEquals((int)0, (int)producer.getInputPorts().size());
                return producer.getOutputPorts();
            }
        });
    }

    @Test
    public void testPortCreationInTestingConsumer() {
        this.checkPortsCreator(new PortsCreator(){

            @Override
            public Map<String, PortType> getPorts(String[] specificationStrings) {
                TestingConsumer consumer = new TestingConsumer(specificationStrings);
                Assert.assertEquals((int)0, (int)consumer.getOutputPorts().size());
                return consumer.getInputPorts();
            }
        });
    }

    private void checkPortsCreator(PortsCreator creator) {
        PortSpec[] specs = new PortSpec[]{new PortSpec("document", "eu.dnetlib.iis.core.schemas.standardexamples.Document", "fake/path/document.json"), new PortSpec("person", "eu.dnetlib.iis.core.schemas.standardexamples.Person", "fake/path/person.json")};
        String[] specsStr = new String[specs.length];
        for (int i = 0; i < specs.length; ++i) {
            specsStr[i] = String.format("{%s, %s, %s}", specs[i].name, specs[i].schemaPath, specs[i].jsonPath);
        }
        Map<String, PortType> outs = creator.getPorts(specsStr);
        Assert.assertEquals((int)specs.length, (int)outs.size());
        for (int i = 0; i < specs.length; ++i) {
            AvroPortType actual = (AvroPortType)outs.get(specs[i].name);
            AvroPortType expected = new AvroPortType(AvroUtils.toSchema((String)specs[i].schemaPath));
            Assert.assertEquals((Object)expected, (Object)actual);
        }
    }
}

