/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java.io;

import com.google.common.io.Files;
import eu.dnetlib.iis.core.TestsIOUtils;
import eu.dnetlib.iis.core.java.io.AvroDataStoreReader;
import eu.dnetlib.iis.core.java.io.DataStoreExamples;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.io.JsonUtils;
import eu.dnetlib.iis.core.schemas.standardexamples.Document;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JsonUtilsTest {
    private File tempDir = null;

    @Before
    public void setUp() throws IOException {
        this.tempDir = Files.createTempDir();
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    @Test
    public void testConvertToDataStoreSimple() throws IOException {
        this.checkConvertToDataStore(DataStoreExamples.getDocument(), "eu/dnetlib/iis/core/java/io/document.json", Document.SCHEMA$);
    }

    @Test
    public void testConvertToDataStoreWithEscapeCodes() throws IOException {
        this.checkConvertToDataStore(DataStoreExamples.getDocumentWithUnicodeEscapeCodes(), "eu/dnetlib/iis/core/java/io/document_with_unicode_escape_codes.json", Document.SCHEMA$);
    }

    private <T> void checkConvertToDataStore(List<T> expectedRecords, String actualResourcePath, Schema actualSchema) throws IOException {
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(actualResourcePath);
        FileSystemPath outPath = new FileSystemPath(new File(this.tempDir, "record"));
        JsonUtils.convertToDataStore((Schema)actualSchema, (InputStream)in, (FileSystemPath)outPath);
        TestsIOUtils.assertEqualSets(expectedRecords, new AvroDataStoreReader(outPath));
    }

    @Test
    public void testConvertToListWithUnicodeEscapeCodes() throws IOException {
        List actual = JsonUtils.convertToList((String)"eu/dnetlib/iis/core/java/io/document_with_unicode_escape_codes.json", (Schema)Document.SCHEMA$, Document.class);
        List<Document> expected = DataStoreExamples.getDocumentWithUnicodeEscapeCodes();
        TestsIOUtils.assertEqualSets(expected, actual);
    }
}

