/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java.io;

import eu.dnetlib.iis.core.java.io.DataStoreExamples;
import eu.dnetlib.iis.core.java.io.JsonStreamWriter;
import eu.dnetlib.iis.core.schemas.standardexamples.Document;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import junit.framework.Assert;
import org.apache.commons.io.IOUtils;
import org.junit.Test;

public class JsonStreamWriterTest {
    @Test
    public void basicTest() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        JsonStreamWriter writer = new JsonStreamWriter(Document.SCHEMA$, (OutputStream)out);
        List<Document> documents = DataStoreExamples.getDocument();
        for (Document d : documents) {
            writer.write((Object)d);
        }
        writer.close();
        String actual = out.toString();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("eu/dnetlib/iis/core/java/io/document.json");
        String expected = JsonStreamWriterTest.toString(in);
        Assert.assertEquals((String)expected, (String)actual);
    }

    private static String toString(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        IOUtils.copy((InputStream)in, (Writer)writer);
        return writer.toString();
    }
}

