/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java.io;

import com.google.common.io.Files;
import eu.dnetlib.iis.core.TestsIOUtils;
import eu.dnetlib.iis.core.java.io.AvroDataStoreReader;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.DataStoreExamples;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.schemas.standardexamples.Document;
import eu.dnetlib.iis.core.schemas.standardexamples.DocumentWithoutTitle;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericContainer;
import org.apache.commons.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DataStoreTest {
    private File tempDir = null;

    @Before
    public void setUp() throws IOException {
        this.tempDir = Files.createTempDir();
    }

    @After
    public void tearDown() throws IOException {
        FileUtils.deleteDirectory((File)this.tempDir);
    }

    @Test
    public void testSingleFile() throws IOException {
        List<Document> documents = DataStoreExamples.getDocument();
        FileSystemPath path = new FileSystemPath(new File(this.tempDir, "doc"));
        DataStore.create(documents, (FileSystemPath)path);
        TestsIOUtils.assertEqualSets(documents, new AvroDataStoreReader(path));
    }

    @Test
    public void testReaderSchema() throws IOException {
        List<Document> documents = DataStoreExamples.getDocument();
        FileSystemPath path = new FileSystemPath(new File(this.tempDir, "doc"));
        DataStore.create(documents, (FileSystemPath)path);
        List<DocumentWithoutTitle> documentsWithoutTitle = DataStoreExamples.getDocumentWithoutTitle();
        TestsIOUtils.assertEqualSets(documentsWithoutTitle, new AvroDataStoreReader(path, DocumentWithoutTitle.SCHEMA$));
    }

    @Test
    public void testClose() throws IOException {
        List<Document> documents = DataStoreExamples.getDocument();
        FileSystemPath path = new FileSystemPath(new File(this.tempDir, "doc"));
        DataStore.create(documents, (FileSystemPath)path);
        AvroDataStoreReader reader = new AvroDataStoreReader(path);
        Assert.assertEquals((Object)documents.get(0), (Object)reader.next());
        Assert.assertEquals((Object)documents.get(1), (Object)reader.next());
        reader.close();
        try {
            reader.next();
            Assert.fail((String)"Didn't throw an exception when it supposed to");
        }
        catch (NoSuchElementException ex) {
            // empty catch block
        }
    }

    @Test
    public void testManyFiles() throws IOException {
        List<Document> documents = DataStoreExamples.getDocument();
        DataStoreTest.createSingleFile(documents.subList(0, 3), new FileSystemPath(new File(this.tempDir, "doc0")), Document.SCHEMA$);
        DataStoreTest.createSingleFile(documents.subList(3, 4), new FileSystemPath(new File(this.tempDir, "doc1")), Document.SCHEMA$);
        TestsIOUtils.assertEqualSets(documents, new AvroDataStoreReader(new FileSystemPath(this.tempDir)));
    }

    @Test
    public void testEmptyFiles() throws IOException {
        List<Document> documents = DataStoreExamples.getDocument();
        DataStoreTest.createSingleFile(documents.subList(0, 3), new FileSystemPath(new File(this.tempDir, "doc0")), Document.SCHEMA$);
        DataStoreTest.createSingleFile(Arrays.asList(new Document[0]), new FileSystemPath(new File(this.tempDir, "doc881")), Document.SCHEMA$);
        DataStoreTest.createSingleFile(documents.subList(3, 4), new FileSystemPath(new File(this.tempDir, "doc22")), Document.SCHEMA$);
        DataStoreTest.createSingleFile(Arrays.asList(new Document[0]), new FileSystemPath(new File(this.tempDir, "doc4")), Document.SCHEMA$);
        TestsIOUtils.assertEqualSets(documents, new AvroDataStoreReader(new FileSystemPath(this.tempDir)));
    }

    private static <T extends GenericContainer> void createSingleFile(List<T> elements, FileSystemPath path, Schema schema) throws IOException {
        DataFileWriter writer = DataStore.createSingleFile((FileSystemPath)path, (Schema)schema);
        for (GenericContainer i : elements) {
            writer.append((Object)i);
        }
        writer.close();
    }
}

