/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java;

import eu.dnetlib.iis.core.java.CmdLineParser;
import eu.dnetlib.iis.core.java.CmdLineParserException;
import eu.dnetlib.iis.core.java.CmdLineParserForProcessRunParameters;
import eu.dnetlib.iis.core.java.PortBindings;
import eu.dnetlib.iis.core.java.Ports;
import eu.dnetlib.iis.core.java.ProcessParameters;
import eu.dnetlib.iis.core.java.porttype.AnyPortType;
import java.net.URISyntaxException;
import java.util.HashMap;
import org.apache.commons.cli.CommandLine;
import org.apache.hadoop.fs.Path;
import org.junit.Assert;
import org.junit.Test;

public class CmdLineParserForProcessRunParametersTest {
    @Test
    public void testBasic() throws URISyntaxException {
        CmdLineParserForProcessRunParameters parser = new CmdLineParserForProcessRunParameters();
        String[] args = new String[]{"-Iperson=/users/joe/person_input", "-Idocument=/users/joe/doc_input", "-Omerged=/users/joe/merged_out", "-SworkingDir=/users/joe/working_dir", "-Page=33"};
        Ports ports = CmdLineParserForProcessRunParametersTest.createStandardPorts();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        ProcessParameters actual = parser.run(cmdLine, ports);
        ProcessParameters expected = CmdLineParserForProcessRunParametersTest.createStandardCmdLineParams();
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test(expected=CmdLineParserException.class)
    public void testTooManyPorts() {
        CmdLineParserForProcessRunParameters parser = new CmdLineParserForProcessRunParameters();
        String[] args = new String[]{"-Iperson=/users/joe/person_input", "-Idocument=/users/joe/doc_input", "-Omerged=/users/joe/merged_out", "-Oother=/users/joe/other_out", "-SworkingDir=/users/joe/working_dir"};
        Ports ports = CmdLineParserForProcessRunParametersTest.createStandardPorts();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        parser.run(cmdLine, ports);
    }

    @Test(expected=CmdLineParserException.class)
    public void testTooFewPorts() {
        CmdLineParserForProcessRunParameters parser = new CmdLineParserForProcessRunParameters();
        String[] args = new String[]{"-Iperson=/users/joe/person_input", "-Omerged=/users/joe/merged_out", "-SworkingDir=/users/joe/working_dir"};
        Ports ports = CmdLineParserForProcessRunParametersTest.createStandardPorts();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        parser.run(cmdLine, ports);
    }

    @Test(expected=CmdLineParserException.class)
    public void testMissingWorkingDir() throws URISyntaxException {
        CmdLineParserForProcessRunParameters parser = new CmdLineParserForProcessRunParameters();
        String[] args = new String[]{"-Iperson=/users/joe/person_input", "-Idocument=/users/joe/doc_input", "-Omerged=/users/joe/merged_out"};
        Ports ports = CmdLineParserForProcessRunParametersTest.createStandardPorts();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        parser.run(cmdLine, ports);
    }

    private static Ports createStandardPorts() {
        HashMap<String, AnyPortType> inputPorts = new HashMap<String, AnyPortType>();
        inputPorts.put("person", new AnyPortType());
        inputPorts.put("document", new AnyPortType());
        HashMap<String, AnyPortType> outputPorts = new HashMap<String, AnyPortType>();
        outputPorts.put("merged", new AnyPortType());
        return new Ports(inputPorts, outputPorts);
    }

    private static ProcessParameters createStandardCmdLineParams() throws URISyntaxException {
        HashMap<String, Path> inputBinding = new HashMap<String, Path>();
        inputBinding.put("person", new Path("/users/joe/person_input"));
        inputBinding.put("document", new Path("/users/joe/doc_input"));
        HashMap<String, Path> outputBinding = new HashMap<String, Path>();
        outputBinding.put("merged", new Path("/users/joe/merged_out"));
        PortBindings expectedBindings = new PortBindings(inputBinding, outputBinding);
        Path expectedWorkingDir = new Path("/users/joe/working_dir");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("age", "33");
        ProcessParameters cmdLineParams = new ProcessParameters(expectedBindings, expectedWorkingDir, params);
        return cmdLineParams;
    }
}

