/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core.java;

import eu.dnetlib.iis.core.java.CmdLineParser;
import eu.dnetlib.iis.core.java.CmdLineParserForProcessConstruction;
import eu.dnetlib.iis.core.java.DummyProcess;
import eu.dnetlib.iis.core.java.DummyProcessWithParametersConstructor;
import eu.dnetlib.iis.core.java.Process;
import org.apache.commons.cli.CommandLine;
import org.junit.Assert;
import org.junit.Test;

public class CmdLineParserForProcessConstructionTest {
    @Test
    public void testTrivial() {
        String[] args = new String[]{"eu.dnetlib.iis.core.java.DummyProcess"};
        CmdLineParserForProcessConstruction cmdLineParser = new CmdLineParserForProcessConstruction();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        Process actual = cmdLineParser.run(cmdLine);
        Assert.assertEquals(DummyProcess.class, actual.getClass());
    }

    @Test
    public void testWithSomeParameters() {
        String[] args = new String[]{"eu.dnetlib.iis.core.java.DummyProcess", "-Iperson=hdfs://localhost:8020/users/joe/person_input", "-Idocument=hdfs://localhost:8020/users/joe/doc_input", "-Omerged=hdfs://localhost:8020/users/joe/merged_out", "-SworkingDir=hdfs://localhost:8020/users/joe/working_dir", "-SclassName=java.util.String"};
        CmdLineParserForProcessConstruction cmdLineParser = new CmdLineParserForProcessConstruction();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        Process actual = cmdLineParser.run(cmdLine);
        Assert.assertEquals(DummyProcess.class, actual.getClass());
    }

    @Test
    public void testWithSomeParametersWithParametersConstructor() {
        String[] constructorParams = new String[]{"some string", "some other string"};
        String[] args = new String[]{"eu.dnetlib.iis.core.java.DummyProcessWithParametersConstructor", "-C" + constructorParams[0], "-C" + constructorParams[1], "-Iperson=hdfs://localhost:8020/users/joe/person_input", "-Idocument=hdfs://localhost:8020/users/joe/doc_input", "-Omerged=hdfs://localhost:8020/users/joe/merged_out", "-SworkingDir=hdfs://localhost:8020/users/joe/working_dir", "-SclassName=java.util.String"};
        CmdLineParserForProcessConstruction cmdLineParser = new CmdLineParserForProcessConstruction();
        CommandLine cmdLine = CmdLineParser.parse((String[])args);
        DummyProcessWithParametersConstructor actual = (DummyProcessWithParametersConstructor)cmdLineParser.run(cmdLine);
        Assert.assertEquals(DummyProcessWithParametersConstructor.class, actual.getClass());
        for (int i = 0; i < constructorParams.length; ++i) {
            Assert.assertEquals((Object)constructorParams[i], (Object)actual.params[i]);
        }
    }
}

