/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import junit.framework.Assert;

public class TestsIOUtils {
    private static final int filesCompareBufferSize = 1024;
    private static final int dumpRecordsCountlimit = 100;

    public static <T> void assertEqualSets(List<T> expected, Iterable<T> actual) {
        TestsIOUtils.assertEqualSets(expected, actual.iterator());
    }

    public static <T> void assertEqualSets(List<T> expected, Iterator<T> actual) {
        ArrayList<T> actualList = new ArrayList<T>();
        while (actual.hasNext()) {
            actualList.add(actual.next());
        }
        TestsIOUtils.assertEqualSets(expected, actualList);
    }

    public static <T> void assertEqualSets(List<T> expected, List<T> actual) {
        Assert.assertEquals((String)String.format("The number of the expected elements (%s) is not equal to the number of the actual elements (%s).\n\n%s", expected.size(), actual.size(), TestsIOUtils.elementsToString(expected, actual)), (int)expected.size(), (int)actual.size());
        boolean[] actualMatched = new boolean[actual.size()];
        for (int i = 0; i < expected.size(); ++i) {
            boolean iMatched = false;
            for (int j = 0; j < actual.size(); ++j) {
                if (actualMatched[j] || !expected.get(i).equals(actual.get(j))) continue;
                actualMatched[j] = true;
                iMatched = true;
                break;
            }
            Assert.assertTrue((String)String.format("The element '%s' that is present among expected elements was not found among the actual elements.\n\n%s", expected.get(i), TestsIOUtils.elementsToString(expected, actual)), (boolean)iMatched);
        }
    }

    private static <T> String elementsToString(List<T> expected, List<T> actual) {
        StringBuilder builder = new StringBuilder();
        builder.append("Dump of compared records:\n");
        builder.append(TestsIOUtils.singleListToString(expected, "Expected"));
        builder.append(TestsIOUtils.singleListToString(actual, "Actual"));
        return builder.toString();
    }

    private static <T> String singleListToString(List<T> elems, String name) {
        StringBuilder builder = new StringBuilder();
        builder.append(name + " records:\n");
        for (int i = 0; i < 100 && i != elems.size(); ++i) {
            builder.append(elems.get(i).toString() + "\n");
        }
        if (elems.size() > 100) {
            builder.append("... (more records available but not shown due to print limit of 100 records)\n");
        }
        return builder.toString();
    }

    public static void assertContentsEqual(String resourcePath, File otherFile) throws FileNotFoundException, IOException {
        TestsIOUtils.assertEqual(Thread.currentThread().getContextClassLoader().getResourceAsStream(resourcePath), new FileInputStream(otherFile));
    }

    public static void assertEqual(InputStream in0, InputStream in1) {
        try {
            Assert.assertTrue((boolean)TestsIOUtils.equal(in0, in1));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean equal(InputStream in0, InputStream in1) throws IOException {
        try {
            byte[] buffer0 = new byte[1024];
            byte[] buffer1 = new byte[1024];
            int bytesRead0 = 0;
            int bytesRead1 = 0;
            while (bytesRead0 > -1) {
                bytesRead0 = in0.read(buffer0);
                if (bytesRead0 != (bytesRead1 = in1.read(buffer1))) {
                    boolean bl = false;
                    return bl;
                }
                if (Arrays.equals(buffer0, buffer1)) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in0 != null) {
                in0.close();
            }
            if (in1 != null) {
                in1.close();
            }
        }
    }
}

