/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core;

import com.google.common.io.Files;
import com.google.protobuf.Message;
import eu.dnetlib.iis.core.OozieTestsIOUtils;
import eu.dnetlib.iis.core.StringReplacer;
import eu.dnetlib.iis.core.java.io.DataStore;
import eu.dnetlib.iis.core.java.io.FileSystemPath;
import eu.dnetlib.iis.core.java.io.protobuf.IOUtils;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public class RemoteOozieAppManager {
    private static final File primedClassDir = new File("target/primed");
    private static final String oozieAppDirName = "oozie_app";
    private static final String sandboxDirName = "working_dir";
    private static final StringReplacer replacer = new StringReplacer();
    private FileSystem hdfs;
    private String hdfsDir;
    private OozieTestsIOUtils ioUtils;
    private Path workingDir;
    private Path oozieAppPath;

    private RemoteOozieAppManager(FileSystem hdfs, Path hdfsTestCaseDir, String oozieAppLocalPath) throws IOException {
        this(hdfs, hdfsTestCaseDir, new File(Thread.currentThread().getContextClassLoader().getResource(oozieAppLocalPath).getPath()));
    }

    private RemoteOozieAppManager(FileSystem hdfs, Path hdfsTestCaseDir, File oozieAppLocalFile) throws IOException {
        this.hdfs = hdfs;
        this.hdfsDir = hdfsTestCaseDir.toUri().getPath();
        this.ioUtils = new OozieTestsIOUtils(hdfs);
        this.workingDir = new Path(this.hdfsDir, sandboxDirName);
        this.hdfs.mkdirs(this.workingDir);
        this.oozieAppPath = new Path(this.hdfsDir, oozieAppDirName);
        RemoteOozieAppManager.copyOozieAppToHDFSWithOnTheFlightChangesHack(this.ioUtils, oozieAppLocalFile, this.oozieAppPath);
    }

    public static RemoteOozieAppManager fromPrimedClassDir(FileSystem hdfs, Path hdfsTestCaseDir, String oozieAppPackage) throws IOException {
        return new RemoteOozieAppManager(hdfs, hdfsTestCaseDir, new File(primedClassDir, oozieAppPackage));
    }

    private static void copyOozieAppToHDFSWithOnTheFlightChangesHack(OozieTestsIOUtils ioUtils, File srcAppPath, Path oozieAppPath) throws IOException {
        File appPath = Files.createTempDir();
        Iterator fIterator = FileUtils.iterateFiles((File)srcAppPath, (IOFileFilter)TrueFileFilter.TRUE, (IOFileFilter)TrueFileFilter.TRUE);
        while (fIterator.hasNext()) {
            File srcFile = (File)fIterator.next();
            String relativePath = RemoteOozieAppManager.getRelativeFilePath(srcAppPath, srcFile);
            File destFile = new File(appPath, relativePath);
            destFile.getParentFile().mkdirs();
            if (!srcFile.getName().equals("workflow.xml")) {
                FileUtils.copyFile((File)srcFile, (File)destFile);
                continue;
            }
            replacer.replace(srcFile, destFile);
        }
        ioUtils.copyLocalToHDFS(appPath, oozieAppPath);
    }

    private static String getRelativeFilePath(File base, File path) {
        String baseStr = base.getAbsolutePath();
        String pathStr = path.getAbsolutePath();
        if (!pathStr.startsWith(baseStr)) {
            throw new RuntimeException(String.format("Base path (\"%s\") doesn't match the begining ofthe path \"%s\"", baseStr, pathStr));
        }
        String rest = pathStr.substring(baseStr.length());
        if (rest.length() != 0 && rest.charAt(0) == File.separatorChar) {
            rest = rest.substring(1);
        }
        return rest;
    }

    public Path getWorkingDir() {
        return this.workingDir;
    }

    public Path getOozieAppPath() {
        return this.oozieAppPath;
    }

    public <T> List<T> readDataStoreFromWorkingDir(String name) throws IOException {
        List records = DataStore.read((FileSystemPath)new FileSystemPath(this.hdfs, new Path(this.getWorkingDir(), name)));
        return records;
    }

    @Deprecated
    public <T extends Message> List<T> readProtoBuffDataStoreFromWorkingDir(Class<T> messageClass, String name) throws IOException {
        List records = IOUtils.readProtobuffDataStore(messageClass, (FileSystemPath)new FileSystemPath(this.hdfs, new Path(this.getWorkingDir(), name)));
        return records;
    }

    public void copyResourceFilesToWorkingDir(Map<String, String> resourcePathToHDFSFileNameMap) throws IOException {
        for (Map.Entry<String, String> entry : resourcePathToHDFSFileNameMap.entrySet()) {
            Path hdfsFile = new Path(this.workingDir, entry.getValue());
            this.ioUtils.copyResourceToHDFS(entry.getKey(), hdfsFile);
        }
    }

    public void copyFilesFromWorkingDir(Map<String, File> hdfsFileNameToLocalFileNameMap) throws IOException {
        for (Map.Entry<String, File> entry : hdfsFileNameToLocalFileNameMap.entrySet()) {
            File localFile = entry.getValue();
            Path hdfsFile = new Path(this.workingDir, entry.getKey());
            this.hdfs.copyToLocalFile(hdfsFile, new Path(localFile.getAbsolutePath()));
        }
    }
}

