/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.util.IOUtils;

public class OozieTestsIOUtils {
    private FileSystem fs;
    private static final String confStorageDirProperty = "hadoop.log.dir";
    private static final String confStorageFileName = "shared_configuration.conf";

    public OozieTestsIOUtils(FileSystem fs) {
        this.fs = fs;
    }

    public void copyResourceToHDFS(String resourcePath, Path destination) throws IOException {
        InputStream in = IOUtils.getResourceAsStream((String)resourcePath, (int)-1);
        FSDataOutputStream out = this.fs.create(destination);
        IOUtils.copyStream((InputStream)in, (OutputStream)out);
    }

    public void copyLocalToHDFS(File source, Path destination) throws IOException {
        Path srcPath = new Path(source.getAbsolutePath());
        this.fs.copyFromLocalFile(srcPath, destination);
    }

    public static void saveConfiguration(Configuration conf) throws IOException {
        File f = new File(System.getProperty(confStorageDirProperty), confStorageFileName);
        DataOutputStream out = new DataOutputStream(new FileOutputStream(f));
        conf.write((DataOutput)out);
        out.close();
    }

    public static Configuration loadConfiguration() throws IOException {
        File f = new File(System.getProperty(confStorageDirProperty), confStorageFileName);
        DataInputStream in = new DataInputStream(new FileInputStream(f));
        Configuration conf = new Configuration();
        conf.readFields((DataInput)in);
        in.close();
        return conf;
    }
}

