/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.iis.core;

import eu.dnetlib.iis.core.OozieTestsIOUtils;
import eu.dnetlib.iis.core.RemoteOozieAppManager;
import eu.dnetlib.iis.core.WorkflowConfiguration;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.test.MiniOozieTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XLog;
import org.junit.After;
import org.junit.Before;

public abstract class AbstractWorkflowTestCase
extends MiniOozieTestCase {
    private static final char WORKFLOW_LOCATION_SEPARATOR = '/';
    private static final String JOB_PROPERTIES_FILE_NAME = "job.properties";

    @Before
    protected void setUp() throws Exception {
        System.setProperty("oozie.log4j.file", "oozie-log4j.properties");
        this.log = new XLog(LogFactory.getLog(((Object)((Object)this)).getClass()));
        super.setUp();
    }

    @After
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public RemoteOozieAppManager runWorkflow(String resourcesOozieAppLocalPath) throws IOException, OozieClientException {
        return this.runWorkflow(resourcesOozieAppLocalPath, new WorkflowConfiguration());
    }

    public RemoteOozieAppManager runWorkflow(String resourcesOozieAppLocalPath, WorkflowConfiguration config) throws IOException, OozieClientException {
        return this.runWorkflow(resourcesOozieAppLocalPath, config, false);
    }

    public RemoteOozieAppManager runWorkflow(String resourcesOozieAppLocalPath, WorkflowConfiguration config, boolean skipPredefinedJobProperties) throws IOException, OozieClientException {
        RemoteOozieAppManager appManager = RemoteOozieAppManager.fromPrimedClassDir(this.getFileSystem(), this.getFsTestCaseDir(), resourcesOozieAppLocalPath);
        Properties props = AbstractWorkflowTestCase.createWorkflowConfiguration(this.createJobConf(), AbstractWorkflowTestCase.getTestUser(), appManager.getOozieAppPath(), appManager.getWorkingDir(), skipPredefinedJobProperties ? null : this.loadPredefinedJobProperties(resourcesOozieAppLocalPath), config.getJobProps());
        this.runWorkflowBasedOnConfiguration(props, config.getTimeoutInSeconds(), config.getExpectedFinishStatus());
        return appManager;
    }

    private Properties loadPredefinedJobProperties(String resourcesOozieAppLocalPath) {
        if (resourcesOozieAppLocalPath != null && resourcesOozieAppLocalPath.contains("/")) {
            try {
                String parentWorkflowDir = resourcesOozieAppLocalPath.substring(0, resourcesOozieAppLocalPath.lastIndexOf(47));
                Properties resultProperties = new Properties();
                resultProperties.load(Thread.currentThread().getContextClassLoader().getResourceAsStream(parentWorkflowDir + '/' + JOB_PROPERTIES_FILE_NAME));
                return resultProperties;
            }
            catch (Exception e) {
                this.log.warn((Object)("unable to load job.properties for workflow location " + resourcesOozieAppLocalPath));
            }
        }
        return null;
    }

    @Deprecated
    public void runWorkflow(Path oozieAppPath, Path workingDir) throws OozieClientException, IOException {
        this.runWorkflow(oozieAppPath, workingDir, WorkflowConfiguration.defaultJobProperties);
    }

    @Deprecated
    public void runWorkflow(Path oozieAppPath, Path workingDir, Properties jobProperties) throws OozieClientException, IOException {
        WorkflowConfiguration config = new WorkflowConfiguration().setJobProps(jobProperties);
        Properties props = AbstractWorkflowTestCase.createWorkflowConfiguration(this.createJobConf(), AbstractWorkflowTestCase.getTestUser(), oozieAppPath, workingDir, null, config.getJobProps());
        this.runWorkflowBasedOnConfiguration(props, config.getTimeoutInSeconds(), config.getExpectedFinishStatus());
    }

    private static Properties createWorkflowConfiguration(JobConf jobConf, String testUser, Path oozieAppPath, Path workingDir, Properties defaultJobProps, Properties runtimeJobProps) throws IOException {
        OozieTestsIOUtils.saveConfiguration((Configuration)jobConf);
        OozieClient wc = LocalOozie.getClient();
        Properties conf = wc.createConfiguration();
        conf.setProperty("oozie.wf.application.path", oozieAppPath.toString());
        conf.setProperty("user.name", testUser);
        conf.setProperty("jobTracker", jobConf.get("mapred.job.tracker"));
        conf.setProperty("nameNode", jobConf.get("fs.default.name"));
        conf.setProperty("queueName", "default");
        conf.setProperty("workingDir", workingDir.toString());
        conf.setProperty("minioozieTestRun", "true");
        if (defaultJobProps != null) {
            conf.putAll((Map<?, ?>)defaultJobProps);
        }
        if (runtimeJobProps != null) {
            conf.putAll((Map<?, ?>)runtimeJobProps);
        }
        return conf;
    }

    private void runWorkflowBasedOnConfiguration(Properties configuration, int timeoutInSeconds, WorkflowJob.Status expectedFinishStatus) throws OozieClientException {
        final OozieClient wc = LocalOozie.getClient();
        final String jobId = wc.submit(configuration);
        AbstractWorkflowTestCase.assertNotNull((Object)jobId);
        WorkflowJob wf = wc.getJobInfo(jobId);
        AbstractWorkflowTestCase.assertNotNull((Object)wf);
        AbstractWorkflowTestCase.assertEquals((Object)WorkflowJob.Status.PREP, (Object)wf.getStatus());
        wc.start(jobId);
        this.waitFor(timeoutInSeconds * 1000, new XTestCase.Predicate(){

            public boolean evaluate() throws Exception {
                WorkflowJob wf = wc.getJobInfo(jobId);
                return wf.getEndTime() != null;
            }
        });
        wf = wc.getJobInfo(jobId);
        this.printErrors(wc, wf);
        AbstractWorkflowTestCase.assertNotNull((Object)wf);
        AbstractWorkflowTestCase.assertEquals((Object)expectedFinishStatus, (Object)wf.getStatus());
    }

    private void printErrors(OozieClient wc, WorkflowJob wf) {
        try {
            for (WorkflowAction wa : wf.getActions()) {
                String errorMessage = wa.getErrorMessage() == null ? "" : wa.getErrorMessage();
                this.log.info("Workflow action {0} {1}", new Object[]{wa.getId(), errorMessage});
                if (!"sub-workflow".equals(wa.getType())) continue;
                WorkflowJob subwf = wc.getJobInfo(wa.getExternalId());
                this.printErrors(wc, subwf);
            }
        }
        catch (OozieClientException oozieClientException) {
            // empty catch block
        }
    }
}

