define avro_load_main
org.apache.pig.piggybank.storage.avro.AvroStorage(
'input_schema_class', '$schema_input_main');

define avro_load_id_mapping
org.apache.pig.piggybank.storage.avro.AvroStorage(
'input_schema_class', '$schema_input_id_mapping');


define avro_store_output
org.apache.pig.piggybank.storage.avro.AvroStorage(
'index', '0',
'output_schema_class', '$schema_output');


define IDREPLACE eu.dnetlib.iis.collapsers.IdReplacerUDF;


idMapping = load '$input_id_mapping' using avro_load_id_mapping;
main = load '$input_main' using avro_load_main;

joined = join idMapping by originalId right outer, main by data.$id_field;
mainWithReplacedIds = foreach joined generate IDREPLACE('main::data.$id_field', *);
flattenMainWithReplacedIds = foreach mainWithReplacedIds generate flatten($0);

store flattenMainWithReplacedIds into '$output' using avro_store_output;
