/*
 * Copyright 2015 georgeathanasopoulos.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.dnetlib.espas.spatial.utils;

import eu.dnetlib.espas.gui.server.utils.EmailUtils;
import eu.dnetlib.espas.gui.shared.User;
import eu.dnetlib.espas.spatial.shared.SpatialQueryStatus;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

/**
 *
 * @author georgeathanasopoulos
 */
public class QueryStatusMonitor extends TimerTask{
    private final Logger _logger = Logger.getLogger(QueryStatusMonitor.class);
   //    every hour run status monitor thread
   private long statusMonitorPeriod = 3600000;
   private QueryDBUtils queryDBUtils;
   private EmailUtils emailUtils;

    public QueryStatusMonitor() {
    }

    @Override
    public void run() {
        processSpatialQueries();
    }

    private void processSpatialQueries() {
      for (SpatialQueryStatus djobStatus : queryDBUtils.getUpdatedUnnotifiedQueries())
         if (djobStatus.getStatus() == SpatialQueryStatus.QueryStatus.COMPLETED || djobStatus.getStatus() == SpatialQueryStatus.QueryStatus.FAILED) {
            try {
               User emailToUser = queryDBUtils.getDownloadRequestUser(djobStatus.getQueryId(),djobStatus.getUserId());
                String id = djobStatus.getQueryId();
                emailUtils.sendDownloadUpdateEmail(emailToUser, "Location query status update", "Your location query with id : " + id + " has " + djobStatus.getStatus().
                   name() + ". Please go to your account page for further details");
                queryDBUtils.updateQueryNotification(djobStatus.getQueryId(), true);
               
            } catch (Exception ex) {
               _logger.error("Exception raised while trying to submit notification email for file location query " + djobStatus.getQueryId(), ex);
            }
         }

    }

    //////////////////////////////////////
    
    public void init(){
      Timer timerTask = new Timer("QueryStatusMonitor",true);
      timerTask.schedule(this, 10*1000, statusMonitorPeriod);
      _logger.info("Download status monitor has started !");
    }

    public long getStatusMonitorPeriod() {
        return statusMonitorPeriod;
    }

    public void setStatusMonitorPeriod(long statusMonitorPeriod) {
        this.statusMonitorPeriod = statusMonitorPeriod;
    }


    public EmailUtils getEmailUtils() {
        return emailUtils;
    }

    public void setEmailUtils(EmailUtils emailUtils) {
        this.emailUtils = emailUtils;
    }   

    public QueryDBUtils getQueryDBUtils() {
        return queryDBUtils;
    }

    public void setQueryDBUtils(QueryDBUtils queryDBUtils) {
        this.queryDBUtils = queryDBUtils.getQueryDBInstance();
    }

    
}
