/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial.utils;

import eu.dnetlib.espas.spatial.shared.SpatialQueryStatus;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

/**
 *
 * @author gathanas
 */
public class SpatialDBMonitor extends TimerTask{
   private static final Logger _logger = Logger.getLogger(SpatialDBMonitor.class);
   private long checkPeriod;
   private QueryDBUtils dbUtils;
   
   public SpatialDBMonitor() {
   }

   
   @Override
   public void run() {
      cleanupExpiredRequests();
   }

   //////////////////////////////////////////////////////////////////////////
   private void cleanupExpiredRequests(){
          List<String> queryIds = dbUtils.getExpiredRequests();
      for(String queryId:queryIds){
         dbUtils.getQueryDBInstance().updateQueryStatus(queryId, SpatialQueryStatus.QueryStatus.EXPIRED, "Query Expiration time has passed. All matching results will be removed.");
         dbUtils.getQueryDBInstance().cleanupExpiredRequest(queryId);
      }
   }
   
   /////////////////////////////////////////////////////////////////////////
   // Bean instantiation 

   public void init() {
      Timer timerTask = new Timer("DownloadMonitor", true);
      timerTask.schedule(this, 10 * 1000, checkPeriod);
      _logger.info("Download status monitor has started !");
   }

   public long getCheckPeriod() {
      return checkPeriod;
   }

   public void setCheckPeriod(long checkPeriod) {
      this.checkPeriod = checkPeriod;
   }

   public QueryDBUtils getDbUtils() {
      return dbUtils;
   }

   public void setDbUtils(QueryDBUtils dbUtils) {
      this.dbUtils = dbUtils.getQueryDBInstance();
   }
   
}
