/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial;

import eu.dnetlib.espas.util.GeometryMetadataHandler;

/**
 *
 * @author gathanas
 */
public class SphereQShape extends CircularQShape{

   public SphereQShape(Point centerPoint, double radious) {
      super(centerPoint, radious);
   }
   
   @Override
   public String getQueryString() {
      int sridCode = GeometryMetadataHandler.getSupportedCRSMapping(this.espasCRS).getSrid();
      String queryConstraint = "st_SetSRID(location::geometry, "+sridCode+")";

      String constraintShape = "st_SetSRID(st_MakePoint(";
      Point p = this.shapePoints.get(0);
        boolean inverted = GeometryMetadataHandler.getSupportedCRSMapping(this.espasCRS).isInvertedXY();
        if(!inverted){
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LON_Cord.name())==null? p.getCoordinate(Point.CartesianCoord.X_Cord.name()): p.getCoordinate(Point.PolarCoord.LON_Cord.name()))+", ";
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LAT_Cord.name())==null?p.getCoordinate(Point.CartesianCoord.Y_Cord.name()):p.getCoordinate(Point.PolarCoord.LAT_Cord.name()))+" ";
        }
        else {
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LAT_Cord.name())==null?p.getCoordinate(Point.CartesianCoord.Y_Cord.name()):p.getCoordinate(Point.PolarCoord.LAT_Cord.name()))+", ";
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LON_Cord.name())==null? p.getCoordinate(Point.CartesianCoord.X_Cord.name()): p.getCoordinate(Point.PolarCoord.LON_Cord.name()))+" ";
        }   

      if (p.getCoordinateSize() > 2)
         constraintShape += ", " + (p.getCoordinate(Point.PolarCoord.R_Cord.name()) == null ? p.getCoordinate(Point.CartesianCoord.Z_Cord.name()) : p.getCoordinate(Point.PolarCoord.R_Cord.name()));

      constraintShape += ")," + sridCode + ")::geometry";

      queryConstraint = "st_3ddistance( ST_3DClosestPoint(" + queryConstraint +" , "+constraintShape+"), "+ constraintShape+")<="+updatedRadious();
      return queryConstraint;
      
   }
   
}
