/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package eu.dnetlib.espas.spatial;

import eu.dnetlib.espas.util.GeometryMetadataHandler;

/**
 *
 * @author georgeathanasopoulos
 */
public class CylinderQShape extends CircularQShape{
    private double minHeight;
    private double maxHeight;
    
    public CylinderQShape(Point centerPoint, double radious, double minHeight, double maxHeight) {
        super(centerPoint, radious);
        this.minHeight=minHeight;
        this.maxHeight=maxHeight;
    }
    
       @Override
   public String getQueryString() {
      int sridCode = GeometryMetadataHandler.getSupportedCRSMapping(this.espasCRS).getSrid();
      String queryConstraint = "st_SetSRID(location::geometry, "+sridCode+")";
      double maxZ = 0.0, minZ = Double.MAX_VALUE;
      String constraintShape = "st_SetSRID(st_MakePoint(";
      Point p = this.shapePoints.get(0);
        boolean inverted = GeometryMetadataHandler.getSupportedCRSMapping(this.espasCRS).isInvertedXY();
        if(!inverted){
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LON_Cord.name())==null? p.getCoordinate(Point.CartesianCoord.X_Cord.name()): p.getCoordinate(Point.PolarCoord.LON_Cord.name()))+", ";
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LAT_Cord.name())==null?p.getCoordinate(Point.CartesianCoord.Y_Cord.name()):p.getCoordinate(Point.PolarCoord.LAT_Cord.name()))+" ";
        }
        else {
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LAT_Cord.name())==null?p.getCoordinate(Point.CartesianCoord.Y_Cord.name()):p.getCoordinate(Point.PolarCoord.LAT_Cord.name()))+", ";
            constraintShape+= ""+(p.getCoordinate(Point.PolarCoord.LON_Cord.name())==null? p.getCoordinate(Point.CartesianCoord.X_Cord.name()): p.getCoordinate(Point.PolarCoord.LON_Cord.name()))+" ";
        }   

      if (p.getCoordinateSize() > 2)
         constraintShape += ", " + (p.getCoordinate(Point.PolarCoord.R_Cord.name()) == null ? p.getCoordinate(Point.CartesianCoord.Z_Cord.name()) : p.getCoordinate(Point.PolarCoord.R_Cord.name()));
  
      constraintShape += ")," + sridCode + ")::geometry";

      queryConstraint = "ST_Distance_Sphere(" + queryConstraint +" , "+ constraintShape+")<="+updatedRadious();
      queryConstraint +=" and st_zmin(location::geometry) >="+minHeight+" and st_zmax(location::geometry)<="+maxHeight+"";
      return queryConstraint;
   }

    
}
