/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.zmq;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.FactoryBean;
import org.zeromq.ZMQ;

public class ZMQFactory
implements FactoryBean {
    private static final Log log = LogFactory.getLog(ZMQFactory.class);
    private int ioThreads = 1;

    public Object getObject() throws Exception {
        if (this.isLibraryLoaded()) {
            return ZMQ.context((int)this.ioThreads);
        }
        return null;
    }

    private boolean isLibraryLoaded() {
        try {
            System.loadLibrary("jzmq");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            log.warn((Object)"cannot load jzmq native library");
            return false;
        }
    }

    public Class<?> getObjectType() {
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    public int getIoThreads() {
        return this.ioThreads;
    }

    public void setIoThreads(int ioThreads) {
        this.ioThreads = ioThreads;
    }
}

