/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.conf;

import eu.dnetlib.conf.AbstractWebappContextProperty;
import eu.dnetlib.conf.PropertyFetcher;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mortbay.jetty.Connector;
import org.mortbay.jetty.handler.ContextHandler;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Required;

public class WebappContextProperyFactory
extends AbstractWebappContextProperty
implements FactoryBean {
    private static final Log log = LogFactory.getLog(WebappContextProperyFactory.class);
    private boolean resolveHostname = false;
    private PropertyFetcher propertyFetcher;

    public Object getObject() throws Exception {
        Properties props = new Properties();
        if (this.getContext() == null) {
            return props;
        }
        props.setProperty("container.context", this.getContext());
        log.debug((Object)"trying to autodetect port and hostame");
        if (this.propertyFetcher.isUnchangedPort()) {
            log.debug((Object)"PORT IS NOT OVERRIDDEN, autodetecting");
            int port = this.getPort(this.getServletContext());
            if (port > 0) {
                props.setProperty("container.port", Integer.toString(port));
            }
        } else {
            log.debug((Object)"PORT IS OVERRIDDEN, NOT autodetecting");
        }
        if (this.propertyFetcher.isUnchangedHostname()) {
            log.debug((Object)"HOST IS NOT OVERRIDDEN, autodetecting");
            String hostname = this.getHost(this.getServletContext());
            if (hostname != null) {
                props.setProperty("container.hostname", hostname);
            }
        } else {
            log.debug((Object)"HOST IS OVERRIDDEN, NOT autodetecting");
        }
        return props;
    }

    public Class<?> getObjectType() {
        return null;
    }

    public boolean isSingleton() {
        return true;
    }

    private int getPort(ServletContext servletContext) {
        try {
            return this.getJettyPort(servletContext);
        }
        catch (Throwable e) {
            log.warn((Object)"cannot obtain port from jetty container, probably not running inside jetty", e);
            return 0;
        }
    }

    private int getJettyPort(ServletContext servletContext) {
        Connector[] connectors;
        for (Connector connector : connectors = ((ContextHandler.SContext)servletContext).getContextHandler().getServer().getConnectors()) {
            if (connector.getPort() <= 0) continue;
            return connector.getPort();
        }
        return 0;
    }

    private String getHost(ServletContext servletContext) {
        try {
            if (this.resolveHostname) {
                return InetAddress.getLocalHost().getCanonicalHostName();
            }
            return InetAddress.getLocalHost().toString().split("/")[1];
        }
        catch (UnknownHostException e) {
            log.warn((Object)"cannot obtain hostname from JVM", (Throwable)e);
            return null;
        }
    }

    public boolean isResolveHostname() {
        return this.resolveHostname;
    }

    public void setResolveHostname(boolean resolveHostname) {
        this.resolveHostname = resolveHostname;
    }

    public PropertyFetcher getPropertyFetcher() {
        return this.propertyFetcher;
    }

    @Required
    public void setPropertyFetcher(PropertyFetcher propertyFetcher) {
        this.propertyFetcher = propertyFetcher;
    }
}

