/*
 * Decompiled with CFR 0.152.
 */
package eu.dnetlib.conf;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyResourceConfigurer;

public class PropertyFetcher
extends PropertyResourceConfigurer
implements InitializingBean {
    private static final Log log = LogFactory.getLog(PropertyFetcher.class);
    boolean unchangedHostname = false;
    boolean unchangedPort = true;

    public void afterPropertiesSet() throws Exception {
        Properties props = this.mergeProperties();
        this.convertProperties(props);
        log.debug((Object)("FOUND A container.hostname property " + props.getProperty("container.hostname")));
        if ("localhost".equals(props.getProperty("container.hostname"))) {
            this.unchangedHostname = true;
        }
        if (props.getProperty("container.port") != null) {
            log.debug((Object)("FOUND A container.port property " + props.getProperty("container.port")));
            this.unchangedPort = false;
        }
        log.debug((Object)("HOST unchanged? " + this.unchangedHostname));
        log.debug((Object)("PORT unchanged? " + this.unchangedPort));
    }

    protected void processProperties(ConfigurableListableBeanFactory arg0, Properties props) throws BeansException {
    }

    public boolean isUnchangedHostname() {
        return this.unchangedHostname;
    }

    public void setUnchangedHostname(boolean unchangedHostname) {
        this.unchangedHostname = unchangedHostname;
    }

    public boolean isUnchangedPort() {
        return this.unchangedPort;
    }

    public void setUnchangedPort(boolean unchangedPort) {
        this.unchangedPort = unchangedPort;
    }
}

