package eu.dnetlib.pace.distance;

import java.util.List;

import com.google.common.collect.Lists;
import com.wcohen.ss.AbstractStringDistance;

import eu.dnetlib.pace.common.AbstractPaceFunctions;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Field;

/**
 * For the rest of the fields delegate the distance measure to the second string library.
 */
public abstract class SecondStringDistanceAlgo extends AbstractPaceFunctions implements DistanceAlgo {
	//	 val aliases = Map(('₁' to '₉') zip ('1' to '9'): _*) ++ Map(('⁴' to '⁹') zip ('4' to '9'): _*) ++ Map('¹' -> '1', '²' -> '2', * '³' -> '3')

	protected AbstractStringDistance ssalgo;

	protected double weight = 0.0;

	protected SecondStringDistanceAlgo(double weight, AbstractStringDistance ssalgo) {
		this.ssalgo = ssalgo;
		this.weight = weight;

	}

	protected abstract double normalize(double d);

	public double distance(String a, String b) {
		return normalize(ssalgo.score(a, b));
	}

	protected double distance(List<String> a, List<String> b) {
		return distance(concat(a), concat(b));
	}

	@Override
	public double distance(Field a, Field b) {
		if (a.getType().equals(Type.String) && b.getType().equals(Type.String)) {
			return distance(a.getValue().toString(), b.getValue().toString());
		}
		if (a.getType().equals(Type.List) && b.getType().equals(Type.List)) {
			return distance(toList(a), toList(b));
		}

		throw new IllegalArgumentException("invalid types\n- A: " + a.toString() + "\n- B: " + b.toString());
	}

	private List<String> toList(Field list) {
		List<String> res = Lists.newArrayList();
		for (Object f : ((List<?>) list.getValue())) {
			res.add(((Field) f).getValue().toString());
		}
		return res;
	}

}
