package eu.dnetlib.pace.distance;

import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.protobuf.GeneratedMessage;

import eu.dnetlib.data.proto.ResultProtos.Result;
import eu.dnetlib.data.proto.ResultProtos.Result.Metadata;
import eu.dnetlib.data.proto.StructuredPropertyProtos.StructuredProperty;
import eu.dnetlib.pace.config.Type;
import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;
import eu.dnetlib.pace.model.MapDocument;

public class ProtoDistance extends AbstractDistance<GeneratedMessage> {

	private String identifier;

	public ProtoDistance(String identifier) {
		this.identifier = identifier;
	}

	@Override
	protected Document toDocument(GeneratedMessage a) {

		Map<String, List<Field>> res = Maps.newHashMap();

		Metadata meta = ((Result) a).getMetadata();
		if (!meta.getTitleList().isEmpty()) {
			res.put("title", transformListSP("title", meta.getTitleList()));
		}

		if (!meta.getDescriptionList().isEmpty()) {
			res.put("description", transformListString("description", meta.getDescriptionList()));
		}

		return new MapDocument(identifier, res);
	}

	private List<Field> transformListSP(final String name, final List<StructuredProperty> input) {
		Function<StructuredProperty, Field> function = new Function<StructuredProperty, Field>() {
			@Override
			public Field apply(StructuredProperty sp) {
				return new Field(Type.String, name, sp.getValue());
			}
		};
		return Lists.newArrayList(Lists.transform(input, function));
	}

	private List<Field> transformListString(final String name, final List<String> input) {
		Function<String, Field> function = new Function<String, Field>() {
			@Override
			public Field apply(String sp) {
				return new Field(Type.String, name, StringUtils.substring(sp, 0, 100));
			}
		};
		return Lists.newArrayList(Lists.transform(input, function));
	}
}
