package eu.dnetlib.pace.distance;

import com.wcohen.ss.AbstractStringDistance;

public class Levenstein extends SecondStringDistanceAlgo {

	public Levenstein(double w) {
		super(w, new com.wcohen.ss.Levenstein());
	}

	protected Levenstein(double w, AbstractStringDistance ssalgo) {
		super(w, ssalgo);
	}

	@Override
	public double getWeight() {
		return super.weight;
	}

	@Override
	protected double normalize(double d) {
		return 1 / Math.pow(Math.abs(d) + 1, 0.1);
	}

}
