package eu.dnetlib.pace.distance;

import eu.dnetlib.pace.config.Config;
import eu.dnetlib.pace.model.Document;

public abstract class AbstractDistance<A> implements Distance<A> {

	protected abstract Document toDocument(A a);

	@Override
	public double between(A a, A b, Config config) {
		return new DistanceScorer(config.fields(), config.conditions()).distance(toDocument(a), toDocument(b));
	}
}
