package eu.dnetlib.pace.condition;

import java.util.List;

import eu.dnetlib.pace.model.Document;
import eu.dnetlib.pace.model.Field;

/**
 * Returns true if the titles in the given documents contains the same numbers, false otherwise.
 * 
 * @author claudio
 *
 */
public class TitleVersionMatch extends AbstractCondition {

	public TitleVersionMatch(List<String> fields) {
		super(fields);
	}

	@Override
	public boolean verify(Document a, Document b) {
		boolean res = true;
		for(String field : fields) {
			String valueA = getValue(a.values(field));
			String valueB = getValue(b.values(field));

			res = res && notNull(valueA) && notNull(valueB) && !checkNumbers(valueA, valueB);
		}
		return res;
	}
	
	private boolean notNull(String s) {
		return s != null;
	}

	private String getValue(List<Field> values) {
		return values != null && !values.isEmpty() ? values.get(0).getValue().toString() : null;
	}

}
