package eu.dnetlib.pace.clustering;

import java.util.Map;
import java.util.Set;

import com.google.common.base.Predicate;

import eu.dnetlib.pace.model.Field;

public class FieldFilter implements Predicate<Field> {
	
	private Map<String, Set<String>> blacklists;
	
	private String filedName;
	
	public FieldFilter(String fieldName, Map<String, Set<String>> blacklists) {
		this.filedName = fieldName;
		this.blacklists = blacklists;
	}
	
	@Override
	public boolean apply(Field f) {
		return !regexMatches(filedName, f.stringValue(), blacklists);
	}
	
	/**
	 * Tries to match the fields in the regex blacklist.
	 * 
	 * @param fieldName
	 * @param value
	 * @return true if the field matches, false otherwise
	 */
	protected boolean regexMatches(String fieldName, String value, Map<String, Set<String>> blacklists) {
		if (blacklists.containsKey(fieldName)) {
			for (final String regex : blacklists.get(fieldName)) {
				if (value.matches(regex)) {
					return true;
				}
			}
		}
		return false;
	}
}
