<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:dnet="eu.dnetlib.data.transform.xml.DataciteToHbaseXsltFunctions"
    xmlns:oaf="http://namespace.openaire.eu/oaf"
    exclude-result-prefixes="xsl datetime exslt xsi" xmlns:dri="http://www.driver-repository.eu/namespace/dri">
    
    
	<xsl:param name="datasourceId" />
	<xsl:param name="namespacePrefix"/>
	 <xsl:output method="xml" version="1.0"
        encoding="UTF-8" indent="yes"/>
    
    <xsl:variable name="identifier" select="//column[./@isID='true']"></xsl:variable>
    
    <xsl:template match="csvRecord">
    <oai:record >
        <header xmlns:dri="http://www.driver-repository.eu/namespace/dri">
        <dri:objIdentifier>
				<xsl:value-of select="concat($namespacePrefix, '::', dnet:md5($identifier))" />
			</dri:objIdentifier>			
			<dri:recordIdentifier>
				<xsl:value-of select="$identifier" />
			</dri:recordIdentifier>			
			<dri:dateOfCollection>
				<xsl:value-of select="datetime:dateTime()" />
			</dri:dateOfCollection>
			<dri:repositoryId>
				<xsl:value-of select="$datasourceId" />
			</dri:repositoryId>
        	<oaf:datasourceprefix>
        		<xsl:value-of select="$namespacePrefix"/>
        	</oaf:datasourceprefix>       
        </header>
        <metadata>
        <xsl:call-template name="copyAll"></xsl:call-template>
        </metadata>
    </oai:record>
    </xsl:template>
    
    <xsl:template name="copyAll" match="@*|*">
        <xsl:copy>
            <xsl:apply-templates select="@*|*|text()" />
        </xsl:copy>
    </xsl:template>
    
</xsl:stylesheet>