<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" 
							 xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:dr="http://www.driver-repository.eu/namespace/dr" 
							 xmlns:dnet="eu.dnetlib.miscutils.functional.xml.DnetXsltFunctions"
							xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:oaa="http://namespace.openaire.eu/oaa" 
							xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:fn="http://www.w3.org/2005/xpath-functions">
	
	<xsl:template match="/">
		<record xmlns:dr="http://www.driver-repository.eu/namespace/dr"
            xmlns:dri="http://www.driver-repository.eu/namespace/dri"
            xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
            xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:oai_dc="http://www.openarchives.org/OAI/2.0/oai_dc/">
            <xsl:variable name="R3D_DS_IDENTIFIER" select="string('openaire____::re3data')"/>
            <xsl:variable name="NS_PREFIX" select="string('re3data_____')"/>
            
            <xsl:copy-of select=".//*[local-name()='header']"/>
            
            <!-- "./*[local-name='']" -->
            <metadata>
            	<ROWS>
            		<xsl:for-each select="//*[local-name()='policy']">
            			<xsl:variable name="policyUrl" select="./*[local-name='policyURL']"/>
            			<xsl:variable name="policyId" select="concat($NS_PREFIX, '::', dnet:md5($policyUrl))"/>
            			<ROW table="policies">
            				 <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="$policyId" /></FIELD>
            				 <FIELD name="id"><xsl:value-of select="$policyId" /></FIELD>
            				 <FIELD name="name"><xsl:value-of select="./*[local-name='policyName']" /></FIELD>
            				 <FIELD name="url"><xsl:value-of select="$policyUrl" /></FIELD>
            			</ROW>
            		</xsl:for-each>
            		
            		<!-- A.M. still to finish!! -->
            		
<!--             		<xsl:for-each select="//*[local-name()='subject']"> -->
<!--             			<xsl:variable name=""></xsl:variable> -->
<!--             			<ROW table="subjects"> -->
<!--             				 <FIELD name="_dnet_resource_identifier_"><xsl:value-of select="" /></FIELD> -->
<!--             				 <FIELD name="id"><xsl:value-of select="" /></FIELD> -->
<!--             				 <FIELD name="name"><xsl:value-of select="" /></FIELD> -->
<!--             				 <FIELD name="semanticclass">DFG</FIELD> -->
<!--             				 <FIELD name="semanticscheme">dnet:subject_classification_typologies</FIELD> -->
<!--             			</ROW> -->
<!--             		</xsl:for-each> -->
            	</ROWS>
			</metadata>
        </record>
    </xsl:template>
</xsl:stylesheet>

