<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
    xmlns:datetime="http://exslt.org/dates-and-times" xmlns:exslt="http://exslt.org/common"
    xmlns:oai="http://www.openarchives.org/OAI/2.0/" xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:dri="http://www.driver-repository.eu/namespace/dri" xmlns:dr="http://www.driver-repository.eu/namespace/dr"
    xmlns:oaf="http://namespace.openaire.eu/oaf" xmlns:dnet="eu.dnetlib.enabling.manager.msro.openaire.datacite.FindRelationXSLTFunctions"
    exclude-result-prefixes="xsl datetime exslt xsi dnet">
    
    <!-- <xsl:param name="repositoryCountry" /> -->
    <xsl:param name="repositoryName" />
    <!-- <xsl:param name="repositoryLink" /> -->
    <xsl:param name="dataSourceId" />
    
    <xsl:template match="/">
        <xsl:variable name="datasourcePrefix" select="normalize-space(//oaf:datasourceprefix)" />
        <xsl:variable name="mid" select="normalize-space(//*[local-name()='identifier' and ./@identifierType='DOI'])" />
        <xsl:choose>
            <xsl:when test="$datasourcePrefix='datacite____'">
                <xsl:variable name="relatedId" select="dnet:getRelatedValue($mid)"/>                
                <xsl:choose>
                    <xsl:when test="string-length($relatedId) = 0">
                        <JUNK />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:call-template name="validRecord">
                            <xsl:with-param name="relatedId" select="$relatedId" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>       	
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="validRecord" />
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    
    <xsl:template name="validRecord">
        <xsl:param name="relatedId" />
        
        <record>
            <xsl:copy-of select="//header" />
            
            <metadata>   
                <xsl:copy-of select="//*[local-name() = 'metadata']/*[local-name() = 'resource']" />
                
                <oaf:collectedDatasourceid><xsl:value-of select="$dataSourceId" /></oaf:collectedDatasourceid>
                <oaf:collectedFrom name="{$repositoryName}" id="{$dataSourceId}" />
                <oaf:hostedBy name="{$repositoryName}" id="{$dataSourceId}" />
                <xsl:if test="$relatedId">
                    <xsl:call-template name="processIds">
                        <xsl:with-param name="s" select="$relatedId" />
                    </xsl:call-template>  
                    <!--                     <oaf:relatedId> <xsl:value-of select="$relatedId"></xsl:value-of></oaf:relatedId> -->
                </xsl:if>
                <xsl:for-each select="//*[local-name() = 'contributor' and ./@contributorType='Funder']/*[local-name() = 'nameIdentifier' and starts-with(text(), 'info:eu-repo/grantAgreement/EC/FP7/')]">
                    <oaf:projectid><xsl:value-of select="concat('corda_______::', substring-after(text(),'info:eu-repo/grantAgreement/EC/FP7/'))"/></oaf:projectid>
                </xsl:for-each>
                <xsl:for-each select="//*[local-name() = 'contributor' and ./@contributorType='Funder']/*[local-name() = 'nameIdentifier' and starts-with(text(), 'info:eu-repo/grantAgreement/WT/WT/')]">
                    <oaf:projectid><xsl:value-of select="concat('welcometrust::', substring-after(text(),'info:eu-repo/grantAgreement/WT/WT/'))"/></oaf:projectid>
                </xsl:for-each>
            </metadata>
        </record>
    </xsl:template>
    
    <xsl:template name="processIds">
        <xsl:param name="s" />
        
        <xsl:choose>
            <xsl:when test="contains($s, ',')">
                <oaf:relatedId><xsl:value-of select="normalize-space(substring-before($s, ','))"/></oaf:relatedId>
                <xsl:call-template name="processIds">
                    <xsl:with-param name="s" select="substring-after($s, ',')" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <oaf:relatedId><xsl:value-of select="normalize-space($s)"/></oaf:relatedId>
            </xsl:otherwise>
        </xsl:choose>
        
    </xsl:template>
    
</xsl:stylesheet>    