<NODE name="SET_INFO" isStart="true" type="SetProviderInfo">
	<DESCRIPTION>Set information about current provider</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
		<PARAM required="true" type="string" name="providerName" managedBy="system">$params.("dataprovider:name")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="fetchOriginals"/>
		<ARC to="obtainParams" />
	</ARCS>
</NODE>

<NODE name="fetchOriginals" type="FetchMDStoreRecords">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("harv_id")$</PARAM>
		<PARAM required="true" type="string" name="mdFormat" managedBy="system">$params.("harv_format")$</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">orig_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="generateRows"/>
	</ARCS>
</NODE>

<NODE name="obtainParams" type="ObtainOpenaireDataSourceParams">
	<DESCRIPTION>Fetch records from MDStore</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="providerId" managedBy="system">$params.("dataprovider:id")$</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="generateRows"/>
	</ARCS>
</NODE>

<NODE name="generateRows" type="ApplyXslt" isJoin="true">
	<DESCRIPTION>Transform original records in DB rows</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="xsltClasspath" managedBy="user" function="listFiles('/eu/dnetlib/msro/openaireplus/workflows/repo-hi/xslt-datacite','xslt')"></PARAM>
		<PARAM required="true" type="string" name="inputEprParam" managedBy="system">orig_epr</PARAM>
		<PARAM required="true" type="string" name="outputEprParam" managedBy="system">packed_row_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="storeRowRecords"/>
	</ARCS>
</NODE>

<NODE name="storeRowRecords" type="StoreMDStoreRecords">
	<DESCRIPTION>Store mdtore records</DESCRIPTION>
	<PARAMETERS>
		<PARAM required="true" type="string" name="mdId" managedBy="system">$params.("tran_id")$</PARAM>
		<PARAM required="true" type="string" name="storingType" managedBy="user" function="validValues(['REFRESH','INCREMENTAL'])">REFRESH</PARAM>
		<PARAM required="true" type="string" name="eprParam" managedBy="system">packed_row_epr</PARAM>
	</PARAMETERS>
	<ARCS>
		<ARC to="success"/>
	</ARCS>
</NODE>
